//
//  YHMyFileListCell.swift
//  galaxy
//
//  Created by edy on 2024/7/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyFileListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHMyFileListCell"
    
    var model: YHSupplementInfo = YHSupplementInfo() {
        didSet {
            titleLabel.text = model.name
            subLabel.text = model.typeName
            
            var text : String = "--"
            var color : UIColor = .failColor
            
            if model.checkStatus == 2 {
                text = "需重传"
                color = .failColor
                arrowImgView.image = UIImage(named: "file_list_right_arrow_red")
            } else if  model.checkStatus == 3 {
                text = "待提交"
                color = .brandMainColor
                arrowImgView.image = UIImage(named: "file_list_right_arrow_blue")
            } else {
                text = "需过滤" + String(model.checkStatus)
                color = UIColor.purple
                arrowImgView.image = UIImage(named: "file_list_right_arrow_blue")
            }
            statusLabel.text = text
            statusLabel.textColor = color
        }
    }

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var isLastCell:Bool = false {
        didSet {
            self.grayView.layer.cornerRadius = isLastCell ?  6.0 : 0.0
            self.grayView.layer.borderWidth = isLastCell ?  1.0 : 0.0
            self.grayView.snp.updateConstraints { make in
                make.top.equalToSuperview().offset(isLastCell ? -6.0 : 0.0)
            }
            self.indexLabel.snp.updateConstraints { make in
                make.centerY.equalToSuperview().offset(isLastCell ? -3 : 0.0)
            }
            self.titleLabel.snp.updateConstraints { make in
                make.top.equalToSuperview().offset(isLastCell ? 16.0+6.0 : 16.0)
            }
            self.statusHoldView.snp.updateConstraints { make in
                make.centerY.equalToSuperview().offset(isLastCell ? -3 : 0.0)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var whiteContentView:UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    lazy var clipsView:UIView = {
        let view = UIView()
        view.clipsToBounds = true
        return view
    }()
    
    lazy var grayView:UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0xDEE5F1)
        view.layer.cornerRadius = 0
        view.layer.borderWidth = 1
        view.layer.borderColor = UIColor.init(hex: 0xDEE5F1).cgColor
        view.clipsToBounds = true
        return view
    }()
    
    lazy var infoView:UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    lazy var indexLabel:UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor
        label1.font = UIFont.PFSC_M(ofSize: 19)
        label1.textAlignment = .left
        return label1
    }()
    
    lazy var titleLabel:UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor
        label1.font = UIFont.PFSC_R(ofSize: 15)
        label1.numberOfLines = 0
        label1.textAlignment = .left
        return label1
    }()
    
    lazy var subLabel:UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor50
        label1.font = UIFont.PFSC_R(ofSize: 12)
        label1.numberOfLines = 0
        label1.textAlignment = .left
        return label1
    }()
    
    lazy var statusLabel : UILabel = {
        let lable0 = UILabel(text: "待提交")
        lable0.textColor = UIColor.brandMainColor
        lable0.font = UIFont.PFSC_M(ofSize: 12)
        lable0.lineBreakMode = .byWordWrapping
        lable0.textAlignment = .right
        return lable0
    }()
    
    private lazy var arrowImgView : UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFill
        view.image = UIImage(named: "file_list_right_arrow_blue")
        return view
    }()
    
    private lazy var statusHoldView : UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        return view
    }()
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        self.contentView.addSubview(self.whiteContentView)
        self.whiteContentView.addSubview(self.clipsView)
        self.clipsView.addSubview(self.grayView)
        self.grayView.addSubview(self.infoView)
        self.infoView.addSubview(self.indexLabel)
        self.infoView.addSubview(self.titleLabel)
        self.infoView.addSubview(self.subLabel)
        
        self.infoView.addSubview(statusHoldView)
        self.statusHoldView.addSubview(arrowImgView)
        self.statusHoldView.addSubview(statusLabel)
        
        self.indexLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        self.indexLabel.setContentHuggingPriority(.required, for: .horizontal)
        
        self.whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.bottom.equalToSuperview()
        }
        
        self.clipsView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.bottom.equalToSuperview()
        }
        
        self.grayView.snp.makeConstraints { make in
            make.left.right.top.bottom.equalToSuperview()
        }
        
        self.infoView.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.left.equalTo(1)
            make.right.equalTo(-1)
            make.bottom.equalTo(-1)
        }
        self.indexLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(16)
        }
        self.titleLabel.snp.makeConstraints { make in
            make.left.equalTo(self.indexLabel.snp.right).offset(15)
            make.top.equalTo(16)
            make.right.equalTo(self.statusHoldView.snp.left)
        }
        
        self.subLabel.snp.makeConstraints { make in
            make.left.equalTo(self.indexLabel.snp.right).offset(15)
            make.top.equalTo(self.titleLabel.snp.bottom).offset(2)
            make.right.equalTo(self.statusHoldView.snp.left)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        self.statusHoldView.snp.makeConstraints { make in
            make.right.equalTo(-26)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(60 + 16)
        }
        self.arrowImgView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.width.equalTo(16)
        }
        self.statusLabel.snp.makeConstraints { make in
            make.right.equalTo(arrowImgView.snp.left).offset(0)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(60)
        }
    }
}
