//
//  YHInformationPerectModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInformationPerfectModel {
    var icon : String = ""
    var name : String = ""
    
    var type : Int = -1 {
        didSet{
            
            isFirstCell = false
            isLastestCell = false
            if type == 0 {
                isFirstCell = true
                name = "主申请人信息"
                icon = "zsqrxx_icon"
            } else if type ==  1 {
                name = "家庭成员信息"
                icon = "jtcyxx_icon"
            } else if type ==  2 {
                name = "基本资料"
                icon = "jbzl_icon"
            } else if type ==  3 {
                name = "学历/专业资格"
                icon = "xlzyzg_icon"
            } else if type ==  4 {
                name = "工作经验"
                icon = "gzjy_icon"
            } else if type ==  5 {
                name = "其他信息"
                icon = "qtxx_icon"
                isLastestCell = true
            }
        }
    }
    
    var status : String = ""
    var color : UIColor = .failColor
    var statusColor : UIColor = .failColor
    var isFinished : Bool = false {
        didSet {
            status = isFinished ? "已完成" : "待完善"
            color = isFinished ? UIColor.mainTextColor : UIColor.labelTextColor2
            statusColor = isFinished ? UIColor.successColor : UIColor.labelTextColor2
//            if type != 1 {
//                icon = isFinished ? icon : icon
//            }
        }
    }
    
    var isDoing : Bool = false {
        didSet {
            color = isFinished ? UIColor.mainTextColor : UIColor.labelTextColor2
            statusColor = isDoing ? UIColor.brandMainColor : UIColor.labelTextColor2
            if type != 1 {
                icon = isDoing ? icon : (icon + "_grey")
            }
        }
    }
    var isNextDoingCell : Bool = false
    var isFirstCell : Bool = false
    var isLastestCell : Bool = false
}
