//
//  YHCertificateUploadTypeCell.swift
//  galaxy
//
//  Created by edy on 2024/3/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCertificateUploadItem {
    var type: YHCertificateUploadType
    var title: String
    var subtitle: String
    init(type:YHCertificateUploadType, title: String, subtitle: String = "") {
        self.type = type
        self.title = title
        self.subtitle = subtitle
    }
}

class YHCertificateUploadItemView: UIView {
    
    var item: YHCertificateUploadItem {
        didSet {
            updateUI()
        }
    }
    lazy var topLine:UIView = {
       let view = UIView()
       view.backgroundColor = .separatorColor
       return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize:14)
        return label
    }()
    
    lazy var subTitleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.labelTextColor2
        label.textAlignment = .center
        label.font = UIFont.PFSC_R(ofSize:11)
        return label
    }()
    
    init(_ item: YHCertificateUploadItem) {
        self.item = item
        super.init(frame:CGRect(x: 0, y: 0, width: KScreenWidth, height: 52.0))
        self.createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.tag = self.item.type.rawValue
        self.addSubview(titleLabel)
        self.addSubview(subTitleLabel)
        self.addSubview(topLine)
        updateUI()
    }
    
    func updateUI() {
        
        self.tag = self.item.type.rawValue
        titleLabel.text = item.title
        subTitleLabel.text = item.subtitle
        subTitleLabel.isHidden = item.subtitle.isEmpty
        
        if item.type == .cancel {
            titleLabel.textColor = UIColor(hexString:"#909090")
            titleLabel.font = UIFont.PFSC_R(ofSize: 14)
        } else {
            titleLabel.textColor = UIColor.mainTextColor
            titleLabel.font = UIFont.PFSC_M(ofSize: 14)
        }
        
        titleLabel.snp.remakeConstraints { make in
            make.height.equalTo(20)
            make.left.right.equalToSuperview()
            if item.subtitle.isEmpty {
                make.centerY.equalToSuperview()
            } else {
                make.bottom.equalTo(self.snp.centerY)
            }
        }
        
        subTitleLabel.snp.remakeConstraints { make in
            make.height.equalTo(16)
            make.left.right.equalToSuperview()
            make.top.equalTo(titleLabel.snp.bottom)
        }
        
        topLine.snp.remakeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.top.equalToSuperview()
            make.height.equalTo(1)
        }
    }
}

class YHCertificateUploadTypeCell: UITableViewCell {
   
    static let cellReuseIdentifier = "YHCertificateUploadTypeCell"

    lazy var itemView: YHCertificateUploadItemView = {
        let view = YHCertificateUploadItemView(YHCertificateUploadItem(type:.camera, title:"拍照上传"))
        return view
    }()
    
    var item: YHCertificateUploadItem! {
        didSet {
            itemView.item = item
        }
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        createUI()
    }
    
    func createUI() {
    
        self.selectionStyle = .none
        contentView.addSubview(itemView)
        itemView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}
