//
//  YHMyDocumentsModel.swift
//  galaxy
//
//  Created by EDY on 2024/3/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHMyDocumentsListModel: SmartCodable {
    var id: Int = 0
    var order_id: Int = 0
    var doc_type_name: String = ""
    var document_check_status: Int = 0
    var name_extra: YHMyDocumentsNameExtraModel = YHMyDocumentsNameExtraModel()
    var template_id: Int = 0
    var doc_type_label: String = ""
    var status: Int = 0
    var status_name: String = ""
    var updated_at: String = ""
    var status_origin: Int = 0
    var file_type: String = ""
    var sign_doc: YHMyDocumentsSignDocModel = YHMyDocumentsSignDocModel()
    var document: YHMyDocumentsDocumentModel = YHMyDocumentsDocumentModel()
    var doc_send: String = ""
    var contract_lock: Int = 0
    var is_second_page: Bool = false
    var audi_opinion: String = ""
    
    
    var  isEditFlag : Bool = false //是否为编辑状态
    var  isSelectedFlag : Bool = true //是否被选择  默认全部全部选择
    
    required init() {
    }
}

class YHMyDocumentsNameExtraModel: SmartCodable {
    var applicant: String = ""
    var user_name: String = ""
    var organization: String = ""
    required init() {
    }
}

class YHMyDocumentsDocumentModel: SmartCodable {
    var id: Int = 0
    var copywriter_id: Int = 0
    var customer_id: Int = 0
    var status: Int = 0
    var modify_sum: Int = 0
    var order_id: Int = 0
    var order_sn: String = ""
    var name: String = ""
    var supplement_id: Int = 0
    var document_key: String = ""
    var finalized_key: String = ""
    var user_type: Int = 0
    var compare_file_url: String = ""
    var deleted_at: String = ""
    var created_at: String = ""
    var updated_at: String = ""
    var submit_at: String = ""
    var tencent_key: String = ""
    var tencent_file_url: String = ""
    var first_submit_at: String = ""
    required init() {
    }
}


class YHMyDocumentsSignDocModel: SmartCodable {
    var is_upload: Int = 0
    var supplement_id: Int = 0
    var doc_send: String = ""
    var status: Int = 0
    var doc_type: Int = 0
    var doc_return: [String] = []
    var doc_electronic: String = ""
    var wx_electronically_signed: Int = 0
    var doc_return_manual: [String] = []
    var doc_type_name: String = ""
    var id: Int = 0
    required init() {
    }
}


class YHMyDocumentsUserModel: SmartCodable {
    var username: String = ""
    var sex: Int = 0
    var is_auth: Bool = false
    var surname: String = ""
    required init() {
    }
}

class YHMyDocumentsModel: SmartCodable {
    var docs: [YHMyDocumentsListModel] = []
    var user_info: YHMyDocumentsUserModel = YHMyDocumentsUserModel()
    required init() {
    }
}

