//
//  YHScoreOptionsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHScoreOptionsView: UIView {
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
        
    }
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    private lazy var nameTextView : UITextView  = {
        let lable0 = UITextView()
        lable0.textColor = UIColor(hex: 0x4E4E4E)
        lable0.font = UIFont.PFSC_R(ofSize: 14)
        lable0.isScrollEnabled = false
        lable0.isEditable = false
        lable0.isSelectable = false
        return lable0
        
    }()
    
    
    lazy var bottomLine : UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
    private lazy var customLabel : UILabel = {
        let customLabel = UILabel(frame: CGRect(x: 0, y: 0, width: 40, height: 20))
        customLabel.text = "-"
        customLabel.font = .PFSC_M(ofSize: 12)
        customLabel.backgroundColor = UIColor(hex:0xF8F9FB)
        customLabel.textColor = UIColor(hex: 0x888F98)
        customLabel.layer.cornerRadius = kCornerRadius3
        customLabel.clipsToBounds = true
        customLabel.textAlignment = .center
        return customLabel
    }()
    
    
//    lazy var testImagV  : UIImageView = {
//        let view = UIImageView(frame: CGRect(x: 0, y: 0, width: 40, height: 20))
//        view.backgroundColor = UIColor.red
//        return view
//    }()
    
    
    
    
    
    var dataModel : YHScoreOptiosModel? {
        didSet {
            updateUI()
        }
    }
}

private extension YHScoreOptionsView {
    func setupUI() {
        backgroundColor = .white
        
        addSubview(bottomLine)
        bottomLine.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        addSubview(nameTextView)
        nameTextView.snp.makeConstraints { make in
            make.top.equalTo(kMargin)
            make.left.right.equalToSuperview()
            make.bottom.equalTo(bottomLine.snp.top).offset(-kMargin)
        }
        
        
//        addSubview(testImagV)
//        testImagV.snp.makeConstraints { make in
//            make.top.equalTo(kMargin)
//            make.left.right.equalToSuperview()
//            make.bottom.equalTo(bottomLine.snp.top).offset(-kMargin)
//        }
        
        
    }
    
    
    func updateUI() {
        guard let model = dataModel else {
            nameTextView.text = "-"
            return
        }
        
        
        customLabel.text = model.scoreValue
        if model.isSelected == true {
            
            nameTextView.attributed.text = """
            \(model.scoreName, .foreground(UIColor.brandMainColor), .font(UIFont.PFSC_R(ofSize: 14)))  \(.view(customLabel, .original(.center)))
            """
            customLabel.backgroundColor = UIColor.brandMainColor8
            customLabel.textColor = UIColor.brandMainColor
            
        } else {
            nameTextView.attributed.text = """
            \(model.scoreName, .foreground(UIColor(hex: 0x4E4E4E)), .font(UIFont.PFSC_R(ofSize: 14)))  \(.view(customLabel, .original(.center)))
            """
            customLabel.backgroundColor = UIColor(hex:0xF8F9FB)
            customLabel.textColor = UIColor.labelTextColor2
        }
    }
}
