//
//  YHScoreTitleView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHScoreTitleView: UIView {
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        setupUI()
        
    }
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    
    //固定高度
    static let viewH : CGFloat = 56.0
    
    private lazy var nameLable : UILabel = {
        let lable0 = UILabel(text: "-")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_M(ofSize: 17)
        return lable0
    }()
    
    
    private lazy var desLable : UILabel = {
        let lable0 = UILabel(text: "-")
        lable0.textColor = UIColor.labelTextColor2
        lable0.font = UIFont.PFSC_R(ofSize: 14)
        return lable0
    }()
}

private extension YHScoreTitleView {
    func setupUI() {
        
        addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview()
            make.height.equalTo(24)
        }
        
        addSubview(desLable)
        desLable.snp.makeConstraints { make in
            make.centerY.equalTo(nameLable.snp.centerY)
            make.left.equalTo(nameLable.snp.right).offset(6)
        }
    }
}

extension YHScoreTitleView {
    func updateWith(_ name: String?,_ text : String?) {
        nameLable.text = name ?? "-"
        desLable.text = text ?? "-"
    }
}
