//
//  YHCommonAlertView.swift
//  galaxy
//
//  Created by EDY on 2024/3/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCommonAlertView: UIView {
    typealias AgreeBlock = () -> ()
    var agreeBlock: AgreeBlock?
    var cancelBlcok: AgreeBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var lineView: UIView!
    var messageLabel: UILabel!
    var agreeButton: UIButton!
    var disAgressButton: UIButton!
    
    var isFullGuestureEnabel : Bool = true //view响应全局手势 默认响应
    
    static func show(_ title: String? = nil, _ message: String? = nil, _ leftButtonString: String? = nil, _ rightButtonString: String? = nil,fullGuestureEnable : Bool = true,cancelCallBack: (() -> Void)? = nil, callBack: @escaping (() -> Void)) {
        let view = YHCommonAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.agreeBlock = callBack
        view.cancelBlcok = cancelCallBack
        view.setContent(title, message, leftButtonString, rightButtonString)
        view.isFullGuestureEnabel = fullGuestureEnable
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    func setContent(_ title: String? = nil, _ message: String? = nil, _ leftButtonString: String? = nil, _ rightButtonString: String? = nil) {
        titleLabel.text = title
        messageLabel.text = message
        disAgressButton.setTitle(leftButtonString, for: .normal)
        agreeButton.setTitle(rightButtonString, for: .normal)
        
        
        
        centerView.snp.remakeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(299)
            //            make.height.equalTo(164)
        }
        
        
        if title?.count == 0 || title == nil {
            lineView.isHidden = true
            
            messageLabel.snp.remakeConstraints { make in
                make.left.equalTo(22)
                make.right.equalTo(-22)
                make.height.greaterThanOrEqualTo(21)
                make.top.equalTo(37)
                make.bottom.equalTo(disAgressButton.snp.top).offset(-20)
            }
            
            
        } else {
            lineView.isHidden = false
            
            messageLabel.snp.remakeConstraints { make in
                make.left.equalTo(22)
                make.right.equalTo(-22)
                make.height.greaterThanOrEqualTo(21)
                make.top.equalTo(lineView.snp.bottom).offset(21)
                make.bottom.equalTo(disAgressButton.snp.top).offset(-20)
            }
        }
        
        if leftButtonString?.isEmpty == false && rightButtonString?.isEmpty == false {
            disAgressButton.isHidden = false
            agreeButton.isHidden = false
            
            disAgressButton.snp.remakeConstraints { make in
                make.top.equalTo(messageLabel.snp.bottom).offset(36)
                make.left.equalTo(16)
                make.bottom.equalTo(-16)
                make.width.equalTo(128)
                make.height.equalTo(45)
            }
            
            agreeButton.snp.remakeConstraints { make in
                make.top.equalTo(disAgressButton.snp.top)
                make.width.equalTo(disAgressButton.snp.width)
                make.height.equalTo(disAgressButton.snp.height)
                make.right.equalToSuperview().offset(-kMargin)
            }
        } else {
            disAgressButton.isHidden = true
            agreeButton.isHidden = false
            
            
            agreeButton.snp.remakeConstraints { make in
                make.top.equalTo(messageLabel.snp.bottom).offset(36)
                make.height.equalTo(45)
                make.right.equalToSuperview().offset(-kMargin)
                make.left.equalToSuperview().offset(kMargin)
                make.bottom.equalToSuperview().offset(-kMargin)
            }
            
            
            if rightButtonString?.isEmpty == true && leftButtonString?.isEmpty == true {
                agreeButton.setTitle("我知道了", for: .normal)
            } else if leftButtonString?.isEmpty == true {
                
            } else {
                agreeButton.setTitle(leftButtonString, for: .normal)
            }
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(299)
            make.height.equalTo(143)
        }
        
        titleLabel = {
            let label = UILabel()
            label.textAlignment = .center
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.numberOfLines = 0
            return label
        }()
        
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.height.equalTo(20)
            make.top.equalTo(16)
        }
        
        messageLabel = {
            let label = UILabel()
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_R(ofSize: 16)
            label.numberOfLines = 0
            return label
        }()
        
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.height.equalTo(42)
            make.top.equalTo(63)
        }
        
        disAgressButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor(hex:0xffffff)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("不同意", for: .normal)
            button.setTitleColor( UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.addTarget(self, action: #selector(disagree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(disAgressButton)
        disAgressButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        
        agreeButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("同意", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(agree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(agreeButton)
        agreeButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        
        lineView = {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            return line
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.height.equalTo(1)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
    }
    
    @objc func agree() {
        if let block = self.agreeBlock {
            block()
        }
        dismiss()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        if isFullGuestureEnabel {
            dismiss()
        }
    }
    
    @objc func disagree() {
        if let block = self.cancelBlcok {
            block()
        }
        dismiss()
    }
    
    func dismiss() {
        removeFromSuperview()
    }
}

extension YHCommonAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
