//
//  YHSignAppendStepView.swift
//  galaxy
//
//  Created by EDY on 2024/8/6.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import IQKeyboardManagerSwift

class YHSignAppendStepView: UIView {
    var backDate: ((String,String) -> Void)?
    var centerView: UIView!
    var titleLabel: UILabel!
    var closeButton: UIButton!
    var tipsView: UIView!
    var iconImageView: UIImageView!
    var tipsLabel: UILabel!
    var sureButton: UIButton!
    var lineView: UIView!
    var nameLabel: UILabel!
    var phoneLabel: UILabel!
    var nameLine: UIView!
    var phoneLine: UIView!
    var nameTextField: UITextField!
    var phoneTextField: UITextField!
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
        addKeyBoardNotify()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x000000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(391)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            label.text = "信息确认"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.width.equalTo(200)
            make.centerX.equalToSuperview()
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "my_cer_sheet_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.height.width.equalTo(24)
            make.top.equalTo(16)
        }
        
        tipsView = {
            let view = UIView()
            view.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.04)
            return view
        }()
        centerView.addSubview(tipsView)
        tipsView.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.left.equalTo(20)
            make.height.width.equalTo(42)
            make.top.equalTo(72)
        }
        
        iconImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "service_step_tips")
            return view
        }()
        tipsView.addSubview(iconImageView)
        iconImageView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(12)
            make.height.width.equalTo(14)
        }
        
        tipsLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.brandMainColor
            label.textAlignment = .left
            label.text = "注意：手机号与姓名必须匹配，否则无法完成签署"
            return label
        }()
        tipsView.addSubview(tipsLabel)
        tipsLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.height.equalTo(18)
            make.right.equalToSuperview()
            make.left.equalTo(33.5)
        }
        
        nameLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.text = "姓名"
            return label
        }()
        centerView.addSubview(nameLabel)
        nameLabel.snp.makeConstraints { make in
            make.top.equalTo(146)
            make.height.equalTo(20)
            make.width.equalTo(60)
            make.left.equalTo(20)
        }
        
        phoneLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.text = "手机号"
            return label
        }()
        centerView.addSubview(phoneLabel)
        phoneLabel.snp.makeConstraints { make in
            make.top.equalTo(198)
            make.height.equalTo(20)
            make.width.equalTo(60)
            make.left.equalTo(20)
        }
        
        nameLine = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(nameLine)
        nameLine.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(182)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        phoneLine = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(phoneLine)
        phoneLine.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(234)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        nameTextField = {
            let textField = UITextField()
//            textField.delegate = self
            textField.textColor = UIColor.mainTextColor
            textField.font = UIFont.PFSC_M(ofSize: 14)
            textField.addTarget(self, action: #selector(textFieldDidChanged), for: .editingChanged)
            textField.placeholder = "请输入姓名"
            return textField
        }()
        centerView.addSubview(nameTextField)
        nameTextField.snp.makeConstraints { make in
            make.top.equalTo(146)
            make.height.equalTo(20)
            make.right.equalTo(-20)
            make.left.equalTo(118)
        }
        
        phoneTextField = {
            let textField = UITextField()
//            textField.delegate = self
            textField.textColor = UIColor.mainTextColor
            textField.font = UIFont.PFSC_M(ofSize: 14)
            textField.addTarget(self, action: #selector(textFieldDidChanged), for: .editingChanged)
            textField.placeholder = "请输入手机号"
            textField.keyboardType = .numberPad
            return textField
        }()
        centerView.addSubview(phoneTextField)
        phoneTextField.snp.makeConstraints { make in
            make.top.equalTo(198)
            make.height.equalTo(20)
            make.right.equalTo(-20)
            make.left.equalTo(118)
        }
        
        sureButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("下一步", for: .normal)
            button.setTitleColor(UIColor.white, for: .normal)
            button.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.3)
            button.isEnabled = false
            button.layer.cornerRadius = 3
            button.addTarget(self, action: #selector(sure), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(sureButton)
        sureButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.height.equalTo(48)
            make.left.equalTo(16)
            make.bottom.equalTo(-46)
        }
                
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        centerView.layoutIfNeeded()
        let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
        let path = UIBezierPath(roundedRect:bounds,byRoundingCorners: corner,cornerRadii:CGSizeMake(kCornerRadius6, kCornerRadius6))
        let layer = CAShapeLayer()
        layer.frame = centerView.bounds
        layer.path = path.cgPath
        centerView.layer.mask = layer
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    static func show(callBack: @escaping ((String,String) -> Void)) {
        let view = YHSignAppendStepView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.backDate = callBack
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func sure() {
        if let block = backDate {
            block(nameTextField.text ?? "", phoneTextField.text ?? "")
        }
        dismiss()
    }
    
    @objc func textFieldDidChanged() {
        if nameTextField.text?.count ?? 0 > 0, phoneTextField.text?.count ?? 0 > 0 {
            sureButton.backgroundColor = UIColor.brandMainColor
            sureButton.isEnabled = true
        } else {
            sureButton.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.3)
            sureButton.isEnabled = false
        }
    }
}

extension YHSignAppendStepView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}

extension YHSignAppendStepView {
    
    func addKeyBoardNotify() {
        
        NotificationCenter.default.addObserver(self, selector: #selector(handleKeyboardNotification(_:)), name: UIResponder.keyboardWillShowNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(handleKeyboardNotification(_:)), name: UIResponder.keyboardWillHideNotification, object: nil)
    }
    
    func removeNotify() {
        NotificationCenter.default.removeObserver(self)
    }
    
    @objc func handleKeyboardNotification(_ notification: Notification) {
        
        if notification.userInfo != nil {
            
            guard let keyboardFrame = (notification.userInfo?[UIResponder.keyboardFrameEndUserInfoKey] as AnyObject).cgRectValue else {return }
            
            let isKeyboardShow = notification.name == UIResponder.keyboardWillShowNotification
            let bottomMargin = (isKeyboardShow ? -keyboardFrame.height : 0)
            
            if !isKeyboardShow {
                IQKeyboardManager.shared.enable = true
            }
            
            self.centerView.snp.updateConstraints { make in
                make.bottom.equalToSuperview().offset(bottomMargin)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
}

