//
//  YHMaterialListModel.swift
//  galaxy
//
//  Created by edy on 2024/9/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

enum YHMaterialType: String {
    // 资料类型(CERT=证件资料  WORK=工作资料  LIVE=生活资料)
    case cer = "CERT"
    case work = "WORK"
    case live = "LIVE"
}

enum YHMaterialStatus: String {
    case all = "ALL" // 自定义
    // (未开始=NOT_OPEN 待上传=TO_BE_UPLOAD  待审核= PENDING_AUDIT  已驳回=REJECTED  已完成= COMPLETED)
    case unOpen = "NOT_OPEN"
    case preUpload = "TO_BE_UPLOAD"
    case review = "PENDING_AUDIT"
    case rejected = "REJECTED"
    case completed = "COMPLETED"
}

class YHMaterialListModel: SmartCodable {

    var id: Int = 0
    var order_sn: String = ""
    var status: String = ""
    var stay_deadline: String = ""
    var material: [YHMaterialModel] = []
    var members: [YHMembersModel] = []
    
    required init() {
        
    }
}

class YHMaterialModel: SmartCodable {
    
    var id: Int = 0
    var renewal_id: Int = 0
    var order_id: Int = 0
    var subset_id: Int = 0
    var information_id: Int = 0
    var template_id: Int = 0
    var relation: Int = 0
    // 资料类型(CERT=证件资料  WORK=工作资料  LIVE=生活资料)
    var mtype: String = ""
    var name: String = ""
    var info: String = ""
    var upload_require: String = ""
    var audit_at: String = ""
    var audit_uid: Int = 0
    // 状态(待上传=TO_BE_UPLOAD  待审核= PENDING_AUDIT  已驳回=REJECTED  已完成= COMPLETED)
    var status: String = ""
    var remark: String = ""
    var audit_remark: String = ""
    var created_at: String = ""
    var updated_at: String = ""
    var deleted_at: String = ""
    
    required init() {
        
    }
}

class YHMembersModel: SmartCodable {
    
    var id: Int = 0
    var renewal_number: Int = 0
    var apply_name: String = ""
    var apply_relation: Int = 0
    var apply_relation_text: String = ""
    
    required init() {
        
    }
}
