//
//  YHResignMaterialViewModel.swift
//  galaxy
//
//  Created by edy on 2024/9/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignMaterialInfo {
    
    var title: String = ""
    var materials: [YHMaterialModel] = []
    
    init(title: String, materials: [YHMaterialModel]) {
        self.title = title
        self.materials = materials
    }
}

class YHResignMaterialGroup {
    
    var status: YHMaterialStatus = .all
    // 工作资料
    var works:[YHMaterialModel] = []
    // 生活资料
    var lifes:[YHMaterialModel] = []
    // 证件资料
    var cers: [YHMaterialModel] = []
    
    func getTotalCount() -> Int {
        return works.count + lifes.count + cers.count
    }
    
    func clear() {
        works.removeAll()
        lifes.removeAll()
        cers.removeAll()
    }
    
    func getDataArr()-> [YHResignMaterialInfo] {
        var arr:[YHResignMaterialInfo] = []
        if works.count > 0 {
            let work = YHResignMaterialInfo(title: "工作资料", materials: works)
            arr.append(work)
        }
        if lifes.count > 0 {
            let life = YHResignMaterialInfo(title: "生活资料", materials: lifes)
            arr.append(life)
        }
        if cers.count > 0 {
            let cer = YHResignMaterialInfo(title: "证件资料", materials: cers)
            arr.append(cer)
        }
        return arr
    }
}

class YHResignMaterialViewModel: NSObject {
    // 全部
    var allGroup: YHResignMaterialGroup = YHResignMaterialGroup()
    // 待上传
    var preuploadGroup: YHResignMaterialGroup = YHResignMaterialGroup()
    // 已驳回
    var rejectedGroup: YHResignMaterialGroup = YHResignMaterialGroup()
    // 审核中
    var reviewGroup: YHResignMaterialGroup = YHResignMaterialGroup()
    // 已完成
    var finishGroup: YHResignMaterialGroup = YHResignMaterialGroup()
    
    func clear() {
        self.allGroup.clear()
        self.preuploadGroup.clear()
        self.rejectedGroup.clear()
        self.reviewGroup.clear()
        self.finishGroup.clear()
    }
    
    func getMaterialList(param:[String : Any], callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignMaterial.resignMaterialList
        let _ = YHNetRequest.getRequest(url: strUrl,params: param) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                
                guard let dic = json.data?.peel as? [String : Any],let resultModel = YHMaterialListModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.clear()
                    callback?(false, err)
                    return
                }
                let materials = resultModel.material
                self.allGroup = self.generateGroup(status: .all, materials:materials)
                self.preuploadGroup = self.generateGroup(status: .preUpload, materials:materials)
                self.rejectedGroup = self.generateGroup(status: .rejected, materials:materials)
                self.reviewGroup = self.generateGroup(status: .review, materials:materials)
                self.finishGroup = self.generateGroup(status: .completed, materials:materials)
                callback?(true, nil)
                
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                self.clear()
                callback?(false, err)
            }
            
        } failBlock: { err in
            self.clear()
            callback?(false, err)
        }
    }
    
    func generateGroup(status: YHMaterialStatus, materials:[YHMaterialModel]) -> YHResignMaterialGroup {
        let group = YHResignMaterialGroup()
        group.status = status
        
        for material in materials {
            let condition: Bool = (status == .all ? true : material.status == status.rawValue)
            if condition {
                if material.mtype == YHMaterialType.work.rawValue {
                    group.works.append(material)
                }
                if material.mtype == YHMaterialType.live.rawValue {
                    group.lifes.append(material)

                }
                if material.mtype == YHMaterialType.cer.rawValue {
                    group.cers.append(material)
                }
            }
        }
        return group
    }
}
