//
//  YHDatePickView.swift
//  galaxy
//
//  Created by EDY on 2024/1/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

struct YHCountryModel {
    var provincesArray: [YHProvincesModel] = []
    init(dic: [String:[String]]) {
        var provices:[YHProvincesModel] = []
        for (key,value) in dic {
            let model = YHProvincesModel(name: key, dic: value)
            provices.append(model)
        }
        
        let strings = ["北京", "上海", "广东", "广西", "天津", "重庆", "河北", "山西", "内蒙古", "辽宁", "吉林", "黑龙江", "江苏", "浙江", "安徽", "福建", "江西", "山东", "河南", "湖北", "湖南","海南", "四川", "贵州", "云南","西藏", "陕西", "甘肃", "青海","宁夏", "新疆", "台湾", "澳门", "香港"]
        
        for item in strings {
            for provice in provices {
                if provice.provincesName.contains(item) {
                    provincesArray.append(provice)
                }
            }
        }
    }
}

struct YHProvincesModel {
    var provincesName: String = ""
    var cityArray: [YHCityModel] = []
    init(name : String ,dic:[String]) {
        provincesName = name
        for value in dic {
            let model = YHCityModel(name: value)
            cityArray.append(model)
        }
    }
}

struct YHCityModel {
    var cityName: String = ""
    init(name: String) {
        cityName = name
    }
}
