//
//  YHItemView.swift
//  galaxy
//
//  Created by EDY on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHItemView: UIView {
    typealias ItemBlock = (_ model: YHItemModel) -> ()
    var block: ItemBlock?
    var titleLabel: UILabel!
    var messageTextField: UITextField!
    var nextStepImageView: UIImageView!
    var centerButton: UIButton!
    var leftButton: UIButton!
    var rightButton: UIButton!
    var showPromptLabel: UILabel!
    var longTimeButton: UIButton!
    var country: String = ""
    var state: Int = 0 {
        didSet {
            if state == 1 || state == 3 {
                nextStepImageView.isHidden = true
                messageTextField.isEnabled = false
            } else {
//                nextStepImageView.isHidden = false
//                messageTextField.isEnabled = true
            }
        }
    }
    
    var dataSource: YHItemModel? {
        didSet {
            updateAllViews()
        }
    }

    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let label = UILabel()
            label.numberOfLines = 0
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
            make.width.equalTo(112)
        }
        
        messageTextField = {
            let textField = UITextField()
            textField.delegate = self
            textField.textColor = UIColor.mainTextColor
            textField.font = UIFont.PFSC_M(ofSize: 14)
            textField.addTarget(self, action: #selector(textFieldDidChanged), for: .editingChanged)
            textField.adjustsFontSizeToFitWidth = true
            //最小字体
            textField.minimumFontSize = 12
            return textField
        }()
        addSubview(messageTextField)
        messageTextField.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(112)
        }
        
        showPromptLabel = {
            let label = UILabel()
            label.textColor = UIColor.failColor
            label.font = UIFont.PFSC_M(ofSize: 12)
            return label
        }()
        addSubview(showPromptLabel)
        showPromptLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.left)
            make.height.equalTo(20)
            make.right.bottom.equalToSuperview()
        }
        
        nextStepImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "form_right_arrow")
            return imageView
        }()
        addSubview(nextStepImageView)
        nextStepImageView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.width.equalTo(20)
        }
        
        centerButton = {
            let button = UIButton(type: .custom)
            button.addTarget(self, action: #selector(centerClick), for: .touchUpInside)
            return button
        }()
        addSubview(centerButton)
        centerButton.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(112)
        }
        
        rightButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.layer.cornerRadius = 16
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.isSelected = true
            button.addTarget(self, action: #selector(rightClick), for: .touchUpInside)
            return button
        }()
        addSubview(rightButton)
        rightButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.equalTo(32)
            make.width.equalTo(74)
        }
        
        leftButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor = UIColor.contentBkgColor
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.layer.cornerRadius = 16
            button.addTarget(self, action: #selector(leftClick), for: .touchUpInside)
            return button
        }()
        addSubview(leftButton)
        leftButton.snp.makeConstraints { make in
            make.right.equalTo(rightButton.snp.left).offset(-12)
            make.centerY.equalToSuperview()
            make.height.equalTo(32)
            make.width.equalTo(74)
        }
        
        longTimeButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "main_time_normal"), for: .normal)
            button.setImage(UIImage(named: "login_privacy_agree"), for: .selected)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.setTitle("长期", for: .normal)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .right
            button.addTarget(self, action: #selector(longTimeButtonClick), for: .touchUpInside)
            button.isSelected = false
            return button
        }()
        addSubview(longTimeButton)
        longTimeButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.equalTo(32)
            make.width.equalTo(43)
        }
        longTimeButton.iconInLeft(spacing: 3)
    }
    
    @objc func longTimeButtonClick() {
        longTimeButton.isSelected = !longTimeButton.isSelected
        if longTimeButton.isSelected {
            self.dataSource?.message = "8888-01-01"
            self.updateAllViews()
            if let block = self.block {
                block(self.dataSource ?? YHItemModel())
            }
        } else {
            self.dataSource?.message = ""
            self.updateAllViews()
            if let block = self.block {
                block(self.dataSource ?? YHItemModel())
            }
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        if dataSource.id == .id23 {
            messageTextField.keyboardType = .asciiCapable
        }
        if dataSource.id == .id29 {
            messageTextField.keyboardType = .numberPad
        }
        if dataSource.isNeed ?? false {
            let str = "* " + (dataSource.title ?? "")
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 14),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 2)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            titleLabel.attributedText = questionAttrStr
        } else {
            let str = dataSource.title ?? ""
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 14),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            titleLabel.attributedText = questionAttrStr
        }
        messageTextField.placeholder = dataSource.prompts
        messageTextField.text = dataSource.message
        showPromptLabel.text = dataSource.alertMessage
        if dataSource.isUserKeyBoard ?? false {
            nextStepImageView.isHidden = true
            centerButton.isHidden = true
        } else {
            if let type = dataSource.type {
                switch type {
                case .id:
                    if dataSource.message == "0" || dataSource.message == "11" {
                        messageTextField.text = ""
                    }
                    let arr = YHConstantArrayData.arrIdType
                    arr.forEach { item in
                        if item["id"] == dataSource.message {
                            messageTextField.text = item["title"]
                        }
                    }
                case .travel:
                    if dataSource.message == "0" {
                        messageTextField.text = ""
                    }
                    let arr = YHConstantArrayData.arrTravelIdType
                    arr.forEach { item in
                        if item["id"] == dataSource.message {
                            messageTextField.text = item["title"]
                        }
                    }
                case .sex:
                    if dataSource.message == "0" {
                        messageTextField.text = ""
                    }
                    let arr = YHConstantArrayData.arrSex
                    arr.forEach { item in
                        if item["id"] == dataSource.message {
                            messageTextField.text = item["title"]
                        }
                    }
                case .marry:
                    if dataSource.message == "0" {
                        messageTextField.text = ""
                    }
                    let arr = YHConstantArrayData.arrMarry
                    arr.forEach { item in
                        if item["id"] == dataSource.message {
                            messageTextField.text = item["title"]
                        }
                    }
                default: break
                }
            }
            nextStepImageView.isHidden = false
            centerButton.isHidden = false
            messageTextField.snp.remakeConstraints { make in
                make.top.bottom.equalToSuperview()
                make.right.equalTo(-20)
                make.left.equalTo(112)
            }
        }
       
        if (dataSource.leftButtonString != nil) {
            leftButton.isHidden = false
            leftButton.setTitle(dataSource.leftButtonString, for: .normal)
            nextStepImageView.isHidden = true
            messageTextField.isHidden = true
            if dataSource.message == "0" || dataSource.message == "2" {
                if dataSource.id == .id25 {
                    buttonState(isLeft: true)
                } else {
                    buttonState(isLeft: false)
                }
            } else {
                if dataSource.id == .id25 {
                    buttonState(isLeft: false)
                } else {
                    buttonState(isLeft: true)
                }
            }
            
        } else {
            leftButton.isHidden = true
        }
        
        if (dataSource.rightButtonString != nil) {
            rightButton.isHidden = false
            rightButton.setTitle(dataSource.rightButtonString, for: .normal)
            nextStepImageView.isHidden = true
            messageTextField.isHidden = true
        } else {
            rightButton.isHidden = true
        }
        
        if dataSource.isShowPrompts ?? false && dataSource.isNeed ?? false {
            if dataSource.message?.count != 0 {
                showPromptLabel.isHidden = true
                if dataSource.type == .sex && dataSource.message == "0" {
                    showPromptLabel.isHidden = false
                }
                //特殊处理身份证
                if dataSource.id == .id8 {
                    if let message = dataSource.message,message.count == 18 {
                    } else {
                        showPromptLabel.isHidden = false
                    }
                }
            } else {
                showPromptLabel.isHidden = false
            }
        } else {
            showPromptLabel.isHidden = true
        }
        
        
        if dataSource.id == .id11 {
            longTimeButton.isHidden = false
            nextStepImageView.isHidden = true
            if dataSource.message == "8888-01-01" {
                longTimeButton.isSelected = true
                longTimeButton.snp.remakeConstraints { make in
                    make.left.equalTo(messageTextField.snp.left)
                    make.centerY.equalToSuperview()
                    make.height.equalTo(32)
                    make.width.equalTo(43)
                }
                centerButton.isHidden = true
                messageTextField.isHidden = true
            } else {
                longTimeButton.isSelected = false
                longTimeButton.snp.remakeConstraints { make in
                    make.right.equalToSuperview()
                    make.centerY.equalToSuperview()
                    make.height.equalTo(32)
                    make.width.equalTo(43)
                }
                centerButton.isHidden = false
                messageTextField.isHidden = false
            }
        } else {
            longTimeButton.isHidden = true
        }
    }
    
    func buttonState(isLeft: Bool) {
        if isLeft {
            leftButton.isSelected = true
            rightButton.isSelected = false
            leftButton.layer.borderWidth = 1
            leftButton.layer.borderColor = UIColor.brandMainColor.cgColor
            leftButton.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
            rightButton.backgroundColor = UIColor.contentBkgColor
            rightButton.layer.borderWidth = 0
            
            leftButton.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
            rightButton.titleLabel?.font = UIFont.PFSC_R(ofSize: 13)
        } else {
            rightButton.isSelected = true
            leftButton.isSelected = false
            rightButton.layer.borderWidth = 1
            rightButton.layer.borderColor = UIColor.brandMainColor.cgColor
            rightButton.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
            leftButton.backgroundColor = UIColor.contentBkgColor
            leftButton.layer.borderWidth = 0
            
            rightButton.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
            leftButton.titleLabel?.font = UIFont.PFSC_R(ofSize: 13)
        }
        
    }
    
    @objc func rightClick() {
        rightButton.isSelected = true
        leftButton.isSelected = false
        rightButton.layer.borderWidth = 1
        rightButton.layer.borderColor = UIColor.brandMainColor.cgColor
        rightButton.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
        leftButton.backgroundColor = UIColor.contentBkgColor
        leftButton.layer.borderWidth = 0
        dataSource?.message = "0"
        dataSource?.value = ["0"]
        if dataSource?.id == .id25 {
            dataSource?.message = "1"
            dataSource?.value = ["1"]
        }
        if let block = block {
            block(dataSource ?? YHItemModel())
        }
        
        rightButton.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
        leftButton.titleLabel?.font = UIFont.PFSC_R(ofSize: 13)
    }
    
    @objc func leftClick() {
        leftButton.isSelected = true
        rightButton.isSelected = false
        leftButton.layer.borderWidth = 1
        leftButton.layer.borderColor = UIColor.brandMainColor.cgColor
        leftButton.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
        rightButton.backgroundColor = UIColor.contentBkgColor
        rightButton.layer.borderWidth = 0
        dataSource?.message = "1"
        dataSource?.value = ["1"]
        if dataSource?.id == .id25 {
            dataSource?.message = "0"
            dataSource?.value = ["0"]
        }
        if let block = block {
            block(dataSource ?? YHItemModel())
        }
        leftButton.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
        rightButton.titleLabel?.font = UIFont.PFSC_R(ofSize: 13)
    }
    
    @objc func centerClick() {
        if state == 1 || state == 3 {
            return
        }
        UIViewController.current?.view.endEditing(true) // 收起键盘
        guard let type = dataSource?.type else { return }
        switch type {
        case .normal:
            printLog("不需要跳转")
        case .address:
            var provice = ""
            if country.contains("台湾") {
                provice = "台湾省"
            }
            if country.contains("香港") {
                provice = "香港特别行政区"
            }
            if country.contains("澳门") {
                provice = "澳门特别行政区"
            }
            let addressPicker = YHAddressViewController(selectProvince: provice)
            addressPicker.backLocationStringController = { (address,province,city,area) in
                self.dataSource?.message = address
                self.dataSource?.value = [province, city]
                self.updateAllViews()
                if let block = self.block {
                    block(self.dataSource ?? YHItemModel())
                }
            }
            UIViewController.current?.present(addressPicker, animated: true, completion: nil)
        case .time:
            var title = ""
            var isLastDay = false
            if dataSource?.id == .id10 || dataSource?.id == .id14 || dataSource?.id == .id19 {
                title = "请选择签发日期"
                isLastDay = true
            }
            if dataSource?.id == .id11 || dataSource?.id == .id15 || dataSource?.id == .id20 {
                title = "请选择届满日期"
                isLastDay = false
            }
            if dataSource?.id == .id24 {
                title = "请选择出生日期"
                isLastDay = true
            }
            YHDatePickView.show(type: .yyyymmdd, title: title, lastIsTaday: isLastDay, currentDay: dataSource?.message ?? "") { date in
                self.dataSource?.message = date
                self.updateAllViews()
                if let block = self.block {
                    block(self.dataSource ?? YHItemModel())
                }
            }
        case .image:
            let view = YHImagePickerView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
            view.backImage = { [weak self] image in
                guard let self = self else { return }
                self.updateAllViews()
                if let block = block {
                    block(dataSource ?? YHItemModel())
                }
            }
            let window = UIApplication.shared.yhKeyWindow()
            window?.addSubview(view)
        case .id:
            YHOtherPickerView.show(type: .idType, selectTitle: self.dataSource?.message ?? "") {[weak self] data in
                guard let self = self else { return }
                self.dataSource?.message = data.title
                self.dataSource?.value = [data.index]
                self.updateAllViews()
                if let block = self.block {
                    block(self.dataSource ?? YHItemModel())
                }
            }
        case .travel:
            YHOtherPickerView.show(type: .travelIdType, selectTitle: self.dataSource?.message ?? "") {[weak self] data in
                guard let self = self else { return }
                self.dataSource?.message = data.title
                self.dataSource?.value = [data.index]
                self.updateAllViews()
                if let block = self.block {
                    block(self.dataSource ?? YHItemModel())
                }
            }
        case .country:
            let vc = YHSelectCountryViewController()
            vc.backLocationStringController = { (country) in
                self.dataSource?.message = country
                self.updateAllViews()
                if let block = self.block {
                    block(self.dataSource ?? YHItemModel())
                }
            }
            UIViewController.current?.navigationController?.pushViewController(vc)
        case .sex:
            YHOtherPickerView.show(type: .sex, selectTitle: self.dataSource?.message ?? "") {[weak self] data in
                guard let self = self else { return }
                self.dataSource?.message = data.title
                self.dataSource?.value = [data.index]
                self.updateAllViews()
                if let block = self.block {
                    block(self.dataSource ?? YHItemModel())
                }
            }
        case .marry:
            YHOtherPickerView.show(type: .marry, selectTitle: self.dataSource?.message ?? "") {[weak self] data in
                guard let self = self else { return }
                self.dataSource?.message = data.title
                self.dataSource?.value = [data.index]
                self.updateAllViews()
                if let block = self.block {
                    block(self.dataSource ?? YHItemModel())
                }
            }
        case .selectAddress: 
            YHOtherPickerView.show(type: .selectAddress, selectTitle: self.dataSource?.message ?? "") {[weak self] data in
                guard let self = self else { return }
                self.dataSource?.message = data.title
                self.dataSource?.value = [data.index]
                self.updateAllViews()
                if let block = self.block {
                    block(self.dataSource ?? YHItemModel())
                }
            }
        default: break
        }
    }
    
    @objc func textFieldDidChanged() {
        if dataSource?.id == .id23 {
            messageTextField.text = messageTextField.text?.uppercased()
        }
    }
}

extension YHItemView: UITextFieldDelegate {
    func textFieldDidEndEditing(_ textField: UITextField) {
        
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        
        if string.isEmpty == true {
            let newText = (textField.text! as NSString).replacingCharacters(in: range, with: string)
            var data = dataSource ?? YHItemModel()
            data.message = newText
            if let block = block {
                block(data)
            }
            return true
        }
        
        if string == "\n" {
            return false
        }
        
        var newText = (textField.text! as NSString).replacingCharacters(in: range, with: string)
        if (dataSource?.id == .id21 || dataSource?.id == .id22 || dataSource?.id == .id23 || dataSource?.id == .id1) && newText.count > 30 {
            return false
        }
        
        if (dataSource?.id == .id4 || dataSource?.id == .id32 || dataSource?.id == .id13 || dataSource?.id == .id32 || dataSource?.id == .id26 || dataSource?.id == .id34 ) && newText.count > 100 {
            return false
        }
        
        if (dataSource?.id == .id12 || dataSource?.id == .id17 ||
            dataSource?.id == .id9 || dataSource?.id == .id13 || dataSource?.id == .id18) && newText.count > 50 {
            return false
        }
        
        if (dataSource?.id == .id29) && newText.count > 20 {
            return false
        }
            
        if (dataSource?.id == .id8 || dataSource?.id == .id35) && newText.count > 18 {
            return false
        }
        
        if dataSource?.id == .id23 {
            let regex = "[^A-Za-z]+"
            textField.limitInputWithPattern(pattern:regex, 30)
            newText = textField.text!.uppercased()
        }
        
        var data = dataSource ?? YHItemModel()
        data.message = newText
        if let block = block {
            block(data)
        }
        return true
    }
}
