//
//  YHAcademicPreviewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHAcademicPreviewModel: SmartCodable {

    var edu_correct: Int  = 0
    var qla_correct: Int  = 0
    var edu_count: Int  = 0
    var qla_count: Int  = 0
    var is_married: Int  = 0
    
    
    var edu_list : [eduListModel]?
    var qla_list : [qlaListModel]?
    
    required init() {
    }
}

class eduListModel: SmartCodable {
    
    var id: Int = -1
    var school_address_aboard: Int = -1
    var college: String = ""
    var type: String = ""
    var admission_time: String = ""
    var graduate_time: String = ""
    var professional: String = ""
    var background: String = ""
    var degree_type: String = ""
    var school_address: schoolAddressModel?
    
    required init() {
    }
}

class qlaListModel: SmartCodable {
    var id: Int = -1
    var qualification: String = ""
    var college: String = ""
    var promulgation: Int = -1
    var college_address: schoolAddressModel?
    var college_address_aboard: Int = -1
    
    required init() {
    }
}

class schoolAddressModel : SmartCodable {
    var country: String = ""
    var area: [String] = []
    var foreign: String = ""
    var details: String = ""
    required init() {
    }
}




