//
//  YHPersonInfoCellView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHPreviewInfoNameAndSubNameItemView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
   
    //title
    private lazy var nameLable : UILabel = {
        let lable0 = UILabel(text: "--")
        lable0.textColor = UIColor.labelTextColor2
        lable0.font = UIFont.PFSC_R(ofSize: 14)
        return lable0
    }()
    
    
    //title
    private lazy var subtitleLable : UILabel = {
        let lable0 = UILabel(text: "--")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_R(ofSize: 14)
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byWordWrapping
        lable0.textAlignment = .right
        return lable0
    }()
    
    private func setupUI() {
        addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(18)
            make.left.equalToSuperview()
            make.width.lessThanOrEqualTo(154)
            make.height.equalTo(20)
        }
        nameLable.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        addSubview(subtitleLable)
        subtitleLable.snp.makeConstraints { make in
            make.top.equalTo(nameLable.snp.top)
            make.right.equalToSuperview()
            make.left.equalTo(nameLable.snp.right).offset(10)
            make.height.greaterThanOrEqualTo(20)
            
            make.bottom.equalToSuperview()
        }
    }
}

extension YHPreviewInfoNameAndSubNameItemView {
    func update(title : String,subtitle : String) {
        nameLable.text = title
        subtitleLable.text = subtitle
        
        //处理特长的字符
        if title.contains("相关工作是否属国际工作经验：") || title.contains("公司营业额/港元(近一年)：") || title.contains("是否在海外居住满1年及以上：")   {
            nameLable.snp.remakeConstraints { make in
                make.top.equalToSuperview().offset(18)
                make.left.equalToSuperview()
                make.width.lessThanOrEqualTo(240)
                make.height.equalTo(20)
            }
            nameLable.setContentCompressionResistancePriority(.required, for: .horizontal)
        } else if title.contains("主申请人或现配偶是否拥有孩子护养权：") {
            nameLable.snp.remakeConstraints { make in
                make.top.equalToSuperview().offset(18)
                make.left.equalToSuperview()
                make.width.lessThanOrEqualTo(260)
                make.height.equalTo(20)
            }
        }
    }
}

