//
//  YHPreviewInfoQuestionAndAnswerItemsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoQuestionAndAnswerItemsView: UIView {
    var dataModel : YHPreviewInfoSessionModel? {
        didSet {
            updateUI()
        }
    }
}

extension YHPreviewInfoQuestionAndAnswerItemsView {
    func updateUI() {
        guard let model = dataModel else { return }
        guard let arrData = model.cellData0,arrData.count > 0 else { return }
        removeSubviews()
        
        var lastTagView : UIView? = nil
        if model.cellTitle.isEmpty {
            
        } else {
            let sessionView = YHPreviewInfoSingleLineTitleView()
            sessionView.updateTitle(title: model.cellTitle)
            addSubview(sessionView)
            sessionView.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.right.equalToSuperview().offset(-18)
                make.left.equalToSuperview().offset(18)
                make.height.equalTo(YHPreviewInfoSingleLineTitleView.viewH)
            }
            lastTagView = sessionView
        }
        
        
        if arrData.count == 1 {
            let item = arrData[0]
            let cellView = YHPreviewInfoQuestionAndAnswerItemView()
            cellView.dataModel = item
            addSubview(cellView)
            if lastTagView == nil {
                cellView.snp.makeConstraints { make in
                    make.top.equalToSuperview()
                    make.right.equalToSuperview().offset(-18)
                    make.left.equalToSuperview().offset(18)
                    make.bottom.equalToSuperview().offset(-21)
                }
                
            } else {
                cellView.snp.makeConstraints { make in
                    make.top.equalTo(lastTagView!.snp.bottom)
                    make.right.equalToSuperview().offset(-18)
                    make.left.equalToSuperview().offset(18)
                    make.bottom.equalToSuperview().offset(-21)
                }
            }
        } else {
            var tmp : UIView? = lastTagView
            for(index,item) in arrData.enumerated() {
                let cellView = YHPreviewInfoQuestionAndAnswerItemView()
                cellView.dataModel = item
                addSubview(cellView)
                
                if index == arrData.count - 1 {
                    
                    if tmp == nil {
                        cellView.snp.makeConstraints { make in
                            make.top.equalToSuperview()
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                            make.bottom.equalToSuperview().offset(-21)
                        }
                    } else {
                        cellView.snp.makeConstraints { make in
                            make.top.equalTo(tmp!.snp.bottom)
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                            make.bottom.equalToSuperview().offset(-21)
                        }
                    }
                    
                } else {
                    
                    if tmp == nil {
                        cellView.snp.makeConstraints { make in
                            make.top.equalToSuperview()
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                        }
                        
                    } else {
                        cellView.snp.makeConstraints { make in
                            make.top.equalTo(tmp!.snp.bottom)
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                        }
                    }
                    
                }
                tmp = cellView
            }
        }
        
    }
}
