//
//  YHImageResultViewController.swift
//  galaxy
//
//  Created by EDY on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHImageResultViewController: YHBaseViewController {
    typealias SuccessHandlerBlock = (_ relult: String) -> Void
    var successHandlerBlock: SuccessHandlerBlock?
    var resultView: UIImageView!
    var bottomView: YHResultBottomView!
    var img: UIImage!
    var viewModel: YHWorkExperienceViewModel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        viewModel = YHWorkExperienceViewModel()
        gk_navTitle = "照片"
        setView()
        // Do any additional setup after loading the view.
    }
    
    func setView() {
        resultView = {
            let step = UIImageView()
            step.contentMode = .scaleAspectFit
            step.image = img
            return step
        }()
        view.addSubview(resultView)
        resultView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.equalTo(view)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom() - 54)
        }
        
        bottomView = {
            let bottom = YHResultBottomView()
            bottom.nextblock = {[weak self] in
                guard let self = self else { return }
                YHHUD.show(.progress(message: "识别中…"))
                self.viewModel.uploadImage(self.img) {[weak self] success, error in
                    guard let self = self else { return }
                    guard let url = success else { return }
                    self.viewModel.getPublicImageUrl(url) {[weak self] success, error in
                        guard let self = self else { return }
                        guard let url = success else { return }
                        self.viewModel.requestFileMessage(url) {[weak self] success, model, error in
                            guard let self = self else { return }
                            if success {
                                YHHUD.hide()
                                if let block = self.successHandlerBlock {
                                    block(model?.content ?? "")
                                    let mineVC = YHWorkExperienceViewController()
                                    var targetVC : UIViewController!
                                    for controller in self.navigationController!.viewControllers {
                                        if controller.isKind(of: mineVC.classForCoder) {
                                            targetVC = controller
                                        }
                                    }
                                    if targetVC != nil {
                                        self.navigationController?.popToViewController(targetVC, animated: true)
                                    }
                                }
                            } else {
                                YHHUD.hide()
                                YHHUD.flash(message: error?.errorMsg ?? "")
                            }
                        }
                    }
                }
            }
            return bottom
        }()
        view.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalTo(view)
            make.height.equalTo(k_Height_safeAreaInsetsBottom() + 64)
        }
    }
}

