//
//  YHWorkExampleMessageTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkExampleMessageTableViewCell: UITableViewCell {
    typealias MessageBlock = (_ message: String) -> ()
    var messageBlock: MessageBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var useButton: UIButton!
    var lineView: UIView!
    var messageLabel: UILabel!
    var dataSource: String?{
        didSet {
            updateAllViews()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .white
        centerView = {
            let view = UIView()
            view.backgroundColor = UIColor.contentBkgColor
            view.layer.cornerRadius = 8
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(6)
            make.bottom.equalTo(-6)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.text = "工作职责范例1"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(16)
            make.height.equalTo(20)
            make.right.equalTo(-120)
        }
        
        useButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor.withAlphaComponent(0.08)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
            button.contentHorizontalAlignment = .center
            button.setTitle("使用此模板", for: .normal)
            button.setTitleColor( UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(submit), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(useButton)
        useButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.top.equalTo(12)
            make.height.equalTo(27)
            make.width.equalTo(80)
        }
        
        lineView = {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            return line
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(47)
            make.height.equalTo(1)
        }
    
        messageLabel = {
            let label = UILabel()
            label.numberOfLines = 0
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.top.equalTo(59)
            make.left.equalTo(16)
        }
    }
    
    @objc func submit() {
        if let block = messageBlock {
            block(dataSource ?? "")
        }
    }
    
    func updateAllViews() {
        messageLabel.text = dataSource
    }
}
