//
//  YHWorkItemListViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/2/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkItemListViewModel: YHBaseViewModel {

    var mainModel: [YHWorkItemListModel]?
    
    override init() {
        super.init()
    }
    
    func requestWorkList(_ orderId: String, callBackBlock:@escaping (_ success: [YHWorkItemListModel]?, _ error:YHErrorModel?)->()) {
//        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.list + "?order_id=\(orderId)"
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.list
        let params: [String : Any] = ["order_id": orderId]
        
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let result = YHWorkModel.deserialize(from: dic) else {
                    callBackBlock([],nil)
                    return
                }
                self.mainModel = result.list
                callBackBlock(self.mainModel, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock([], error)
            }
        } failBlock: { err in
            callBackBlock([],err)
        }
    }
    
    func requestDeleteWorkExperience(_ orderId: String, callBackBlock:@escaping (_ success: Bool?, _ error:YHErrorModel?)->()) {
        let params: [String : Any] = ["id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.del
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSaveAllWorkExperience(_ orderId: String, callBackBlock:@escaping (_ success: Bool?, _ error:YHErrorModel?)->()) {
        let params: [String : Any] = ["order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.saveAll
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
