//
//  YHServiceOrderProgressTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/4/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

// 我的方案本地红点信息key
let kMyPlanRedPointInfoKey = "kMyPlanRedPointInfoKey"
// 我的评分本地红点信息key
let kMyScoreRedPointInfoKey = "kMyScoreRedPointInfoKey"

// 红点信息pro_version key
let kProVersionKey = "pro_version"
// 红点信息是否点击 key
let kClickKey = "click"
// 订单号
let kOrderIdKey = "order_id"


class YHServiceOrderProgressTableViewCell: UITableViewCell {
    
    let redPointWidth = 6.0
    
    var titleLabel: UILabel!
    var messageLabel: UILabel!
    var buttonLabel: UILabel!
    var progressImageView: UIImageView!
    var progressLabel: UILabel!
    var progress: YHProgressView!
    var redPointView: UIView!
    var dataModel : YHServiceCenterProgressModel?
    var orderId: Int = 0
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

extension YHServiceOrderProgressTableViewCell {

    func set(dataModel: YHServiceCenterProgressModel?, orderId:Int) {
        self.dataModel = dataModel
        self.orderId = orderId
        updateUI()
    }
    
    func updateUI() {
        guard let model = dataModel else { return }
        progress.isHidden = false
        progressImageView.isHidden = false
        progressLabel.isHidden = false
        messageLabel.snp.remakeConstraints { make in
            make.top.equalTo(49)
            make.left.equalTo(21)
            make.right.equalTo(-122)
        }
        messageLabel.text = "您还有" + "\(model.num)" + "份信息待填写哦~"
        // 0未知 1待开始 2进行中 3 已完成
        if model.status == 1 {
            titleLabel.textColor = UIColor.mainTextColor50
            messageLabel.textColor = UIColor.yhGreyColor50
            buttonLabel.text = "待开始"
            buttonLabel.backgroundColor = UIColor(hex: 0xb8babe,transparency: 0.5)
            progressImageView.image = UIImage(named: "service_progress_normal")
            // 1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
            if model.type == 1 {
                titleLabel.text = "我的证件"
                messageLabel.text = "您的证件还没生成哦~"
            }
            if model.type == 2 {
                titleLabel.text = "我的信息"
            }
            if model.type == 3 {
                titleLabel.text = "我的评分"
                messageLabel.text = "如果显示后端问题"
            }
            if model.type == 4 {
                titleLabel.text = "我的方案"
                messageLabel.text = "您的专属方案还没生成哦~"
            }
            if model.type == 5 {
                titleLabel.text = "我的签字"
                messageLabel.text = "您的文件还没签字哦~"
            }
            if model.type == 6 {
                titleLabel.text = "我的文书"
                messageLabel.text = "您的文书还没确认哦~"
            }
            let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
            let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
            progressLabel.attributed.text = b + bb
            if model.type == 22 {
                titleLabel.text = "家庭信息确认"
                messageLabel.text = "请确认现阶段信息是否存在变更～"
            }
            
            if model.type == 21 {
                titleLabel.text = "新增受养人"
                messageLabel.text = "如需，建议现阶段新增，激活后新增需香港住址证明"
                progress.isHidden = true
                progressImageView.isHidden = true
                progressLabel.isHidden = true
                messageLabel.snp.remakeConstraints { make in
                    make.top.equalTo(49)
                    make.left.equalTo(21)
                    make.right.equalTo(-21)
                }
            }
            
            if model.type == 24 {
                titleLabel.text = "赴港办证预约"
                messageLabel.text = "请填写意向办证时间，银河代预约～"
            }
            
            if model.type == 23 {
                titleLabel.text = "电子签证缴费"
                messageLabel.text = "请根据指引缴费领取电子签证～"
            }
            
            if model.type == 25 {
                titleLabel.text = "赴港行程指引"
                messageLabel.text = "请根据指引清单提前规划赴港行程"
                progressImageView.isHidden = true
                progressLabel.isHidden = true
                messageLabel.snp.remakeConstraints { make in
                    make.top.equalTo(49)
                    make.left.equalTo(21)
                    make.right.equalTo(-21)
                }
            }
            
            if model.type == 26 {
                titleLabel.text = "旅行证件准备"
                messageLabel.text = "请更新所有赴港人员的旅行证件"
            }
            
            if model.type == 27 {
                titleLabel.text = "上传过关证件"
                messageLabel.text = "点击保存入境小白条及香港身份证（后续身份续期、永居均涉及）"
            }
            
            if model.type == 31 {
                titleLabel.text = "续签资料管理"
                messageLabel.text = "请确认您的续签文书内容并完成签字~"
            }
            
            if model.type == 32 {
                titleLabel.text = "续签文书管理"
                messageLabel.text = "点击保存入境小白条及香港身份证（后续身份续期、永居均涉及）"
            }
        }
        if model.status == 2 {
            titleLabel.textColor = UIColor.mainTextColor
            buttonLabel.text = "进行中"
            buttonLabel.backgroundColor = UIColor.brandMainColor
            progressImageView.image = UIImage(named: "service_progress_start")
            progress.changeColor(UIColor.brandMainColor)
            // 1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
            if model.type == 1 {
                titleLabel.text = "我的证件"
//                messageLabel.text = "恭喜您，证件已全部上传完~"
                buttonLabel.text = "去上传"
                let a: ASAttributedString = .init("您还有", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                let aa: ASAttributedString = .init(NSAttributedString(string: "\(model.num)份"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("证件待上传哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                messageLabel.attributed.text = a + aa + aaa
            }
            if model.type == 2 {
                titleLabel.text = "我的信息"
                buttonLabel.text = "去填写"
                if model.reject_status == 0 {
                    let a: ASAttributedString = .init("您还有", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                    let aa: ASAttributedString = .init(NSAttributedString(string: "\(model.num)份"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                    let aaa: ASAttributedString = .init("信息待填写哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                    messageLabel.attributed.text = a + aa + aaa
                } else {
                    let a: ASAttributedString = .init("您的信息被", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                    let aa: ASAttributedString = .init(NSAttributedString(string: "驳回"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.failColor))
                    let aaa: ASAttributedString = .init("了哦～", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                    messageLabel.attributed.text = a + aa + aaa
                    buttonLabel.text = "去修改"
                }
            }
            if model.type == 3 {
                titleLabel.text = "我的评分"
                messageLabel.text = "后端出问题会显示"
            }
            if model.type == 4 {
                titleLabel.text = "我的方案"
                messageLabel.text = "后端出问题会显示"
            }
            if model.type == 5 {
                titleLabel.text = "我的签字"
                buttonLabel.text = "去签字"
                let a: ASAttributedString = .init("您还有", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                let aa: ASAttributedString = .init(NSAttributedString(string: "\(model.num)份"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("文件待签字哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                messageLabel.attributed.text = a + aa + aaa
            }
            if model.type == 6 {
                titleLabel.text = "我的文书"
                buttonLabel.text = "去确认"
                if model.percentage == 66 {
                    let a: ASAttributedString = .init("您的文书正在", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                    let aa: ASAttributedString = .init(NSAttributedString(string: "审核中"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                    let aaa: ASAttributedString = .init("哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                    messageLabel.attributed.text = a + aa + aaa
                    buttonLabel.text = "请稍候"
                    buttonLabel.backgroundColor = UIColor.yhGreyColor50
                } else {
                    let a: ASAttributedString = .init("您还有", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                    let aa: ASAttributedString = .init(NSAttributedString(string: "\(model.num)份"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                    let aaa: ASAttributedString = .init("文书待返稿哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                    messageLabel.attributed.text = a + aa + aaa
                }
                
            }
            let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor.mainTextColor))
            let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
            progressLabel.attributed.text = b + bb
            
            if model.type == 11 {
                titleLabel.text = "港府获批结果"
                messageLabel.text = "正在等待原则批结果~"
                buttonLabel.text = "去查看"
                buttonLabel.backgroundColor = UIColor.brandMainColor
                messageLabel.textColor = UIColor.yhGreyColor50
                progress.changeColor(UIColor.brandMainColor)
                progressImageView.image = UIImage(named: "service_progress_normal")
                let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
                let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
                progressLabel.attributed.text = b + bb
            }
            
            if model.type == 12 {
                titleLabel.text = "港府获批结果"
                messageLabel.text = "正在进行原则批补件~"
                buttonLabel.text = "去查看"
                buttonLabel.backgroundColor = UIColor.brandMainColor
                messageLabel.textColor = UIColor.yhGreyColor50
                progress.changeColor(UIColor.brandMainColor)
                progressImageView.image = UIImage(named: "service_progress_normal")
                let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
                let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
                progressLabel.attributed.text = b + bb
            }
            
            if model.type == 13 {
                titleLabel.text = "港府获批结果"
                messageLabel.text = "恭喜您，原则批已获批~"
                buttonLabel.text = "去查看"
                buttonLabel.backgroundColor = UIColor.brandMainColor
                messageLabel.textColor = UIColor.yhGreyColor50
                progress.changeColor(UIColor.brandMainColor)
                progressImageView.image = UIImage(named: "service_progress_start")
                let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor.mainTextColor))
                let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
                progressLabel.attributed.text = b + bb
            }
            
            if model.type == 14 {
                titleLabel.text = "港府获批结果"
                messageLabel.text = "很遗憾，您未获批准~"
                buttonLabel.text = "去查看"
                buttonLabel.backgroundColor = UIColor(hex: 0x55cba0)
                messageLabel.textColor = UIColor.yhGreyColor50
                progress.changeColor(UIColor(hex: 0x55cba0))
                progressImageView.image = UIImage(named: "service_progress_end")
                let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor.mainTextColor))
                let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
                progressLabel.attributed.text = b + bb
            }
            
            if model.type == 15 {
                titleLabel.text = "港府获批结果"
                messageLabel.text = "恭喜您，正式批已获批~"
                buttonLabel.text = "去查看"
                buttonLabel.backgroundColor = UIColor(hex: 0x55cba0)
                messageLabel.textColor = UIColor.yhGreyColor50
                progress.changeColor(UIColor(hex: 0x55cba0))
                progressImageView.image = UIImage(named: "service_progress_end")
                let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor.mainTextColor))
                let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
                progressLabel.attributed.text = b + bb
            }
            
            if model.type == 22 {
                titleLabel.text = "家庭信息确认"
                messageLabel.text = "请确认现阶段信息是否存在变更～"
                buttonLabel.text = "待确认"
                messageLabel.textColor = UIColor.yhGreyColor50
            }
            
            if model.type == 21 {
                titleLabel.text = "新增受养人"
                messageLabel.text = "如需，建议现阶段新增，激活后新增需香港住址证明"
                buttonLabel.text = "待完善"
                progress.isHidden = true
                progressImageView.isHidden = true
                progressLabel.isHidden = true
                messageLabel.textColor = UIColor.yhGreyColor50
                messageLabel.snp.remakeConstraints { make in
                    make.top.equalTo(49)
                    make.left.equalTo(21)
                    make.right.equalTo(-21)
                }
            }
            
            if model.type == 24 {
                titleLabel.text = "赴港办证预约"
                if model.percentage == 50 {
                    messageLabel.text = "抢号中～"
                } else {
                    messageLabel.text = "请填写意向办证时间，银河代预约～"
                }
                buttonLabel.text = "去查看"
                messageLabel.textColor = UIColor.yhGreyColor50
            }
            
            if model.type == 23 {
                titleLabel.text = "电子签证缴费"
                messageLabel.text = "请根据指引缴费领取电子签证～"
                buttonLabel.text = "待缴费"
                messageLabel.textColor = UIColor.yhGreyColor50
            }
            
            if model.type == 25 {
                titleLabel.text = "赴港行程指引"
                messageLabel.text = "请根据指引清单提前规划赴港行程"
                buttonLabel.text = "去查看"
                messageLabel.textColor = UIColor.yhGreyColor50
                progressImageView.isHidden = true
                progressLabel.isHidden = true
                messageLabel.snp.remakeConstraints { make in
                    make.top.equalTo(49)
                    make.left.equalTo(21)
                    make.right.equalTo(-21)
                }
            }
            
            if model.type == 26 {
                titleLabel.text = "旅行证件准备"
                messageLabel.text = "请更新所有赴港人员的旅行证件"
                buttonLabel.text = "去上传"
                messageLabel.textColor = UIColor.yhGreyColor50
            }
            
            if model.type == 27 {
                titleLabel.text = "上传过关证件"
                messageLabel.text = "点击保存入境小白条及香港身份证（后续身份续期、永居均涉及）"
                buttonLabel.text = "去上传"
                messageLabel.textColor = UIColor.yhGreyColor50
            }
            if model.type == 31 {
                titleLabel.text = "续签资料管理"
                messageLabel.text = "请确认您的续签文书内容并完成签字~"
                buttonLabel.text = "去上传"
            }
            
            if model.type == 32 {
                titleLabel.text = "续签文书管理"
                messageLabel.text = "点击保存入境小白条及香港身份证（后续身份续期、永居均涉及）"
                buttonLabel.text = "去确认"
            }
        }
        if model.status == 3 {
            titleLabel.textColor = UIColor.mainTextColor
            messageLabel.textColor = UIColor.yhGreyColor
            buttonLabel.text = "去查看"
            progress.changeColor(UIColor(hex: 0x55cba0))
            buttonLabel.backgroundColor = UIColor(hex: 0x55cba0)
            progressImageView.image = UIImage(named: "service_progress_end")
            // 1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
            if model.type == 1 {
                titleLabel.text = "我的证件"
                messageLabel.text = "恭喜您，证件已全部上传完~"
            }
            if model.type == 2 {
                titleLabel.text = "我的信息"
                messageLabel.text = "恭喜您，信息已全部填写完~"
            }
            if model.type == 3 {
                titleLabel.text = "我的评分"
                messageLabel.text = "恭喜您，自评报告已生成~"
            }
            if model.type == 4 {
                titleLabel.text = "我的方案"
                messageLabel.text = "恭喜您，专属方案已生成~"
            }
            if model.type == 5 {
                titleLabel.text = "我的签字"
                messageLabel.text = "恭喜您，文件已全部签字完~"
            }
            if model.type == 6 {
                titleLabel.text = "我的文书"
                messageLabel.text = "恭喜您，文书已全部定稿~"
            }
            
            if model.type == 15 {
                titleLabel.text = "港府获批结果"
                messageLabel.text = "恭喜您，正式批已获批~"
                buttonLabel.text = "去查看"
            }
            
            if model.type == 22 {
                titleLabel.text = "家庭信息确认"
                messageLabel.text = "请确认现阶段信息是否存在变更～"
                buttonLabel.text = "已完成"
            }
            
            if model.type == 24 {
                titleLabel.text = "赴港办证预约"
                messageLabel.text = "请填写意向办证时间，银河代预约～"
                buttonLabel.text = "已完成"
            }
            
            if model.type == 23 {
                titleLabel.text = "电子签证缴费"
                messageLabel.text = "请根据指引缴费领取电子签证～"
                buttonLabel.text = "已完成"
            }
            
            if model.type == 26 {
                titleLabel.text = "旅行证件准备"
                messageLabel.text = "请更新所有赴港人员的旅行证件"
                buttonLabel.text = "已完成"
            }
            
            if model.type == 27 {
                titleLabel.text = "上传过关证件"
                messageLabel.text = "点击保存入境小白条及香港身份证（后续身份续期、永居均涉及）"
                buttonLabel.text = "已完成"
            }
            
            if model.type == 31 {
                titleLabel.text = "续签资料管理"
                messageLabel.text = "请确认您的续签文书内容并完成签字~"
                buttonLabel.text = "已完成"
            }
            
            if model.type == 32 {
                titleLabel.text = "续签文书管理"
                messageLabel.text = "点击保存入境小白条及香港身份证（后续身份续期、永居均涉及）"
                buttonLabel.text = "已完成"
            }
            let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor.mainTextColor))
            let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
            progressLabel.attributed.text = b + bb
            
        }
        if model.status == 4 {
            titleLabel.textColor = UIColor.mainTextColor
            buttonLabel.text = "请稍候"
            buttonLabel.backgroundColor = UIColor.yhGreyColor50
            progressImageView.image = UIImage(named: "service_progress_start")
            progress.changeColor(UIColor.brandMainColor)
            // 1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
            if model.type == 1 {
                titleLabel.text = "我的证件"
//                messageLabel.text = "恭喜您，证件已全部上传完~"
                let a: ASAttributedString = .init("您的", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                let aa: ASAttributedString = .init(NSAttributedString(string: "证件清单"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("正在制作中哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                messageLabel.attributed.text = a + aa + aaa
            }
            if model.type == 2 {
                titleLabel.text = "我的信息"
                messageLabel.attributed.text = "如果显示后端问题"
            }
            if model.type == 3 {
                titleLabel.text = "我的评分"
                let a: ASAttributedString = .init("您的", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                let aa: ASAttributedString = .init(NSAttributedString(string: "自评报告"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("正在制作中哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                messageLabel.attributed.text = a + aa + aaa
            }
            if model.type == 4 {
                titleLabel.text = "我的方案"
                let a: ASAttributedString = .init("您的", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                let aa: ASAttributedString = .init(NSAttributedString(string: "专属方案"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("正在制作中哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                messageLabel.attributed.text = a + aa + aaa
            }
            if model.type == 5 {
                titleLabel.text = "我的签字"
                let a: ASAttributedString = .init("您的", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                let aa: ASAttributedString = .init(NSAttributedString(string: "签字清单"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("正在制作中哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                messageLabel.attributed.text = a + aa + aaa
            }
            if model.type == 6 {
                titleLabel.text = "我的文书"
                let a: ASAttributedString = .init("您的", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                let aa: ASAttributedString = .init(NSAttributedString(string: "文书清单"), .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.brandMainColor))
                let aaa: ASAttributedString = .init("正在制作中哦~", .font(UIFont.PFSC_M(ofSize: 13)),.foreground(UIColor.yhGreyColor))
                messageLabel.attributed.text = a + aa + aaa
            }
            let b: ASAttributedString = .init(NSAttributedString(string: "\(model.percentage)"), .font(UIFont(name: "DINAlternate-Bold", size: 24)!),.foreground(UIColor.mainTextColor))
            let bb: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 10)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.3)))
            progressLabel.attributed.text = b + bb
        }
        if model.percentage == 0 {
            progress.setProgress(0, animated: false)
            progress.isHidden = true
        } else {
            progress.setProgress(Float(CGFloat(model.percentage))/100.0, animated: false)
            progress.isHidden = false
        }
        
        // 处理我的评分和我的方案红点相关显示逻辑
        // 1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
        if model.type == 3 || model.type == 4 {
            if model.status == 3 { // 只有已完成状态才有红点显示逻辑处理 否则都隐藏
                if model.type == 3 {
                    if model.pro_version == 0 {
                        messageLabel.text = "恭喜您，自评报告已生成~"
                    } else  {
                        messageLabel.text = "恭喜您，方案评分已更新~"
                    }
                    self.redPointView.isHidden = !isNeedShowRedPointFor(key: kMyScoreRedPointInfoKey, proVersion: model.pro_version)
                } else if model.type == 4 {
                    
                    if model.pro_version == 1 {
                        messageLabel.text = "恭喜您，专属方案报告已生成~"
                    } else  {
                        messageLabel.text = "恭喜您，专属方案报告已更新~"
                    }
                    self.redPointView.isHidden = !isNeedShowRedPointFor(key: kMyPlanRedPointInfoKey, proVersion: model.pro_version)
                }
            } else {
                self.redPointView.isHidden = true
            }
            
        } else {
            self.redPointView.isHidden = true
        }
    }
    
    func setupUI() {
        let holdView = UIView()
        holdView.backgroundColor = .white
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        holdView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(21)
            make.left.equalTo(21)
            make.height.equalTo(24)
        }
        
        messageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 13)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            return label
        }()
        holdView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.top.equalTo(49)
            make.left.equalTo(21)
            make.right.equalTo(-122)
        }
        
        buttonLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 13)
            label.textColor = .white
            label.backgroundColor = UIColor.brandMainColor
            label.layer.cornerRadius = 2.0
            label.masksToBounds = true
            label.textAlignment = .center
            return label
        }()
        holdView.addSubview(buttonLabel)
        buttonLabel.snp.makeConstraints { make in
            make.bottom.equalTo(-19)
            make.left.equalTo(21)
            make.height.equalTo(27)
            make.width.equalTo(57)
        }
        
        progressImageView = {
            let view = UIImageView()
            return view
        }()
        holdView.addSubview(progressImageView)
        progressImageView.snp.makeConstraints { make in
            make.top.equalTo(24)
            make.right.equalTo(-32)
            make.height.equalTo(80)
            make.width.equalTo(80)
        }
        
        progressLabel = {
            let label = UILabel()
            label.textAlignment = .center
//            label.font = UIFont.PFSC_M(ofSize: 13)
//            label.textColor = UIColor.mainTextColor
            return label
        }()
        holdView.addSubview(progressLabel)
        progressLabel.snp.makeConstraints { make in
            make.center.equalTo(progressImageView.snp.center)
            make.width.equalTo(60)
            make.height.equalTo(29)
        }
        
        progress = {
            let view = YHProgressView(frame: CGRect(x: 0, y: 0, width: 80, height: 80))
            return view
        }()
        holdView.addSubview(progress)
        progress.snp.makeConstraints { make in
            make.top.equalTo(24)
            make.right.equalTo(-32)
            make.height.equalTo(80)
            make.width.equalTo(80)
        }
        
        redPointView = {
            let view = UIView()
            view.isHidden = true
            view.backgroundColor = .failColor
            view.layer.cornerRadius = self.redPointWidth/2.0
            view.clipsToBounds = true
            return view
        }()
        holdView.addSubview(redPointView)
        redPointView.snp.makeConstraints { make in
            make.width.equalTo(redPointWidth)
            make.height.equalTo(redPointWidth)
            make.left.equalTo(titleLabel.snp.right).offset(2)
            make.top.equalTo(titleLabel.snp.top).offset(2)

        }
    }
    
    func isNeedShowRedPointFor(key: String, proVersion: Int) -> Bool {
        if key != kMyPlanRedPointInfoKey && key != kMyScoreRedPointInfoKey {
            return false
        }
        let targetKey = key + "_\(self.orderId)"
        if let dict = UserDefaults.standard.object(forKey: targetKey) as? [String: Any] {
            if !dict.keys.contains(kProVersionKey) ||  !dict.keys.contains(kClickKey) {
                return false
            }
            if let version = dict[kProVersionKey] as? Int {
                if version != proVersion { // 版本不一致一定显示红点
                    return true
                }
                // 版本一致但是未点击显示红点
                if let isClicked = dict[kClickKey] as? Bool, isClicked == false {
                    return true
                }
            }
            return false
        }
        // 本地没有红点记录存储则必展示红点
        return true
    }
}
