//
//  YHServiceStepAlertVIew.swift
//  galaxy
//
//  Created by EDY on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceStepAlertView: UIView {
    typealias Block = (Int) -> ()
    var block: Block?
    var centerView: UIView!
    var orderButton: UIButton!
    var guideButton: UIButton!
    var isStepOne: Bool = false {
        didSet {
            if isStepOne {
                orderButton.isSelected = false
                guideButton.isSelected = true
            } else {
                orderButton.isSelected = true
                guideButton.isSelected = false
            }
        }
    }
    
    static func show(_ flag: Bool = false, callBack: @escaping ((Int) -> Void)) {
        let view = YHServiceStepAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.isStepOne = flag
        view.block = callBack
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius8
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.height.equalTo(120)
            make.width.equalTo(135)
            make.top.equalTo(85)
        }
        
        orderButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "service_step_select"), for: .selected)
            button.setTitle("续签阶段", for: .normal)
            button.setImage(UIImage.init(color: UIColor.white, size: CGSize(width: 15, height: 15)), for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
            button.setBackgroundColor(color: UIColor.white, forState: .normal)
            button.setBackgroundColor(color: UIColor.brandMainColor8, forState: .selected)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.addTarget(self, action: #selector(orderButtonClick), for: .touchUpInside)
            button.isSelected = false
            return button
        }()
        centerView.addSubview(orderButton)
        orderButton.snp.makeConstraints { make in
            make.right.equalTo(0)
            make.height.equalTo(52)
            make.width.equalTo(135)
            make.top.equalTo(8)
        }
        
        guideButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "service_step_select"), for: .selected)
            button.setTitle("办证阶段", for: .normal)
            button.setImage(UIImage.init(color: UIColor.white, size: CGSize(width: 15, height: 15)), for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
            button.setBackgroundColor(color: UIColor.white, forState: .normal)
            button.setBackgroundColor(color: UIColor.brandMainColor8, forState: .selected)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.addTarget(self, action: #selector(guideButtonClick), for: .touchUpInside)
            button.isSelected = false
            return button
        }()
        centerView.addSubview(guideButton)
        guideButton.snp.makeConstraints { make in
            make.right.equalTo(0)
            make.height.equalTo(52)
            make.width.equalTo(135)
            make.bottom.equalTo(-8)
        }
        orderButton.iconInRight(with: 32)
        guideButton.iconInRight(with: 32)
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func orderButtonClick() {
        if let block = block {
            block(1)
        }
        dismiss()
    }
    
    @objc func guideButtonClick() {
        if let block = block {
            block(2)
        }
        dismiss()
    }
}

extension YHServiceStepAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
