//
//  YHJsApi.swift
//  dsbridgedemo
//
//  Created by du on 2018/9/7.
//  Copyright © 2018年 杜文. All rights reserved.
//

import Foundation
import UIKit

typealias JSCallback = (String, Bool)->Void
typealias JSDicCallback = ([String : Any],Bool)->Void

class YHJsApi: NSObject {
    weak var delegate : YHBaseViewController? = nil
}

extension YHJsApi {
    //4、跳转到 办证3 - 赴港时间预约界面
    @objc func gotoAppointCertificateSyn(_ orderID : String) {
        DispatchQueue.main.async {
            if let orderId = Int(orderID) {
                let vc = YHCertificateAppointViewController()
                vc.orderId = orderId
                self.delegate?.navigationController?.pushViewController(vc)
            }
        }
    }
    
    //3、展示图片组
    @objc func showPicsSyn(_ dicPics: String) {
        DispatchQueue.main.async {
            if let data = dicPics.data(using: .utf8) {
                do {
                    if let jsonObject = try JSONSerialization.jsonObject(with: data, options: []) as? [String: Any] {
                        // 转换成功，jsonObject 是一个字典
                        print("JSON字符串转换为字典成功: \(jsonObject)")
                        
                        if !jsonObject.isEmpty {
                            let curIndex : Int = jsonObject["curIndex"] as? Int ?? -1
                            let arrPics : [String] = jsonObject["pics"] as? [String] ?? []
                            if curIndex > -1,arrPics.count > 0 {
                                YHPictureReviewManager.shared.showNetWorkPicturs(curIndex: curIndex, arrPicturs: arrPics)
                            }
                        } else {
                            printLog("ddddd")
                        }
                    } else {
                        printLog("JSON字符串不是有效的字典格式")
                    }
                } catch {
                    printLog("JSON解析错误: \(error)")
                }
            }
        }
    }
    
    //2、设置app导航栏隐藏、显示
    @objc func setAppNavigation(_ tag : Any) {
        let tmp : Bool = tag as? Bool ?? false
        DispatchQueue.main.async {
            if let delegate = self.delegate as? YHH5WebViewVC {
                delegate.setAppNavigation(tmp)
            }
            
        }
    }
    
    //1、保存图片到本地
    @objc func saveLocalPictureSyn(_ picUrl: String) {
        DispatchQueue.main.async {
            
            if let delegate = self.delegate as? YHH5WebViewVC {
                delegate.saveLocalPictureSyn(picUrl)
            }
        }
    }
}
