//
//  YHLoginStyleButton.swift
//  galaxy
//
//  Created by EDY on 2023/12/26.
//

import UIKit

class YHLoginStyleButton: UIButton {
    var messageLabel: UILabel!
    var headImageView: UIImageView!
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        headImageView = {
            let imageView = UIImageView()
            return imageView
        }()
        addSubview(headImageView)
        headImageView.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
            make.width.equalTo(18)
        }
        
        messageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 16)
            label.textColor = UIColor(hex:0xffffff)
            label.textAlignment = .right
            return label
        }()
        addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(20)
        }
    }
    
    func setContent(image: UIImage, message: String) {
        headImageView.image = image
        messageLabel.text = message
    }
}
