//
//  YHDeviceInfoViewController.swift
//  galaxy
//
//  Created by edy on 2024/4/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHDeviceInfoViewController: YHBaseViewController {
    
    lazy var deviceInfoLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize:15)
        label.numberOfLines = 0
        return label
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
        view.addSubview(deviceInfoLabel)
        deviceInfoLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar)
        }
        
        YHHUD.show(.progress(message: "加载中..."))

        JPUSHService.registrationIDCompletionHandler {
            
            resCode, registrationID in
            YHHUD.hide()
            YHLoginManager.shared.deviceTokenModel.registerId = registrationID ?? ""
            
            var info = "deviceToken: \n" + (YHLoginManager.shared.deviceTokenModel.deviceToken)
            info += "\n"
            info += "\nregisterId: \n" +  (YHLoginManager.shared.deviceTokenModel.registerId)
            printLog("\(info)")
            DispatchQueue.main.async {
                self.deviceInfoLabel.text = info
            }
        }
    }
    
}

