//
//  YHEditViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/6/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHEditViewModel: YHBaseViewModel {
    var model: YHUserNameCardInfo = YHUserNameCardInfo()
    var didChange: Bool = false
    override init() {
        super.init()
    }
    
    func requestChangeHead(callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.change
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let result = YHChangeHeadModel.deserialize(from: dic) else {
                    callBackBlock(false,nil)
                    return
                }
                self.model.avatar = result.avatar
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func getBaseDataSource() -> [YHUserInformationModel] {
        let item1 = YHUserInformationModel(id: .id1, title: "真实姓名", isUserKeyBoard: true, prompts: "请输入您的真实姓名", message: model.username, isNeed: true)
        let item2 = YHUserInformationModel(id: .id6, title: "所在地", isUserKeyBoard: false, prompts: "请选择您的所在地", message: model.address.country, type: .country, isNeed: true)
        var string = ""
        if model.address.province.count != 0 {
            string = model.address.province + "/" + model.address.city
        }
         
        let item3 = YHUserInformationModel(id: .id2, title: "所在地-省市", isUserKeyBoard: false, prompts: "请选择您的所在地", message: string, type: .address, isNeed: true)
        let item4 = YHUserInformationModel(id: .id7, title: "星座", isUserKeyBoard: false, prompts: "请选择您的星座", message: model.zodiac, type: .constellation, isNeed: false)
        if model.address.country.contains("中国") {
            return [item1, item2, item3, item4]
        }
        return [item1, item2, item4]
    }
    
    func updateModel(_ item: YHUserInformationModel) {
        guard let type = item.id else { return }
        switch type {
        case .id1:
            model.username = item.message ?? ""
        case .id2:
            model.address.province = item.value?.first ?? ""
            model.address.city = item.value?.last ?? ""
        case .id3:
            model.college = item.message ?? ""
        case .id4:
            model.industry = item.message ?? ""
        case .id5:
            model.position = item.message ?? ""
        case .id6:
            model.address.country = item.message ?? ""
        case .id7:
            model.zodiac = item.message ?? ""
        case .id8:
            model.major = item.message ?? ""
        case .id9:
            model.background = item.message ?? ""
        case .id10:
            model.companyName = item.message ?? ""
        }
        didChange = true
    }

    func getBaseSchoolDataSource() -> [YHUserInformationModel] {
        let item1 = YHUserInformationModel(id: .id3, title: "毕业院校", isUserKeyBoard: true, prompts: "请输入您的毕业院校", message: model.college, isNeed: true)
        let item2 = YHUserInformationModel(id: .id8, title: "专业", isUserKeyBoard: true, prompts: "请输入您的专业", message: model.major, isNeed: false)
        let item3 = YHUserInformationModel(id: .id9, title: "学位", isUserKeyBoard: false, prompts: "请选择您的学位", message: model.background, type: .degree, isNeed: false)
        
        return [item1, item2, item3]
    }
    
    func getBaseWorkDataSource() -> [YHUserInformationModel] {
        let item1 = YHUserInformationModel(id: .id10, title: "所在企业", isUserKeyBoard: true, prompts: "请输入您的所在企业", message: model.companyName, isNeed: false)
        let item2 = YHUserInformationModel(id: .id5, title: "职位", isUserKeyBoard: true, prompts: "请输入您的职位", message: model.position, isNeed: true)
        let item3 = YHUserInformationModel(id: .id4, title: "所在行业", isUserKeyBoard: false, prompts: "请选择您的所在行业", message: model.industry, type: .id, isNeed: true)
        
        return [item1, item2, item3]
    }
    
    func requestSaveUserInfo(callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let username = model.username.trimmingCharacters(in: .whitespaces)
        if username.count == 0 {
            YHHUD.flash(message: "名字不合法")
            return
        }
        let address: [String: Any] = ["country": model.address.country,
                                      "province": model.address.province,
                                      "city": model.address.city]
        let basic: [String: Any] = ["avatar": model.avatar,
                                    "username": username,
                                    "zodiac": model.zodiac,
                                    "address": address,
                                    "signature": model.signature,
                                    "is_update": true]
        let params: [String: Any] = ["basic_info": basic]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.cardSave
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSavePersonalProfile(callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let introduction: [String: Any] = ["bio": model.bio, "is_update": true]
        let params: [String: Any] = ["introduction": introduction]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.cardSave
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSaveWork(callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let work: [String: Any] = ["company_name": model.companyName,
                                   "position": model.position,
                                   "industry": model.industry,
                                   "is_update": true]
        let params: [String: Any] = ["work": work]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.cardSave
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSaveSchool(callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let education: [String: Any] = ["college": model.college,
                                        "major": model.major,
                                        "background": model.background,
                                        "is_update": true]
        let params: [String: Any] = ["education": education]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.cardSave
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSaveAward(callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let award: [String: Any] = ["honor": model.honor, "is_update": true]
        let params: [String: Any] = ["award": award]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.cardSave
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSaveTopics(topics: [String], draft_topics: [String], callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let interest: [String: Any] = ["is_update": true, "topics": topics, "draft_topics": draft_topics]
        let params: [String: Any] = ["interest": interest]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.cardSave
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func isCanNext(step: Int = 1) -> Bool {
        if step == 1 {
            let avatar = model.avatar
            let username = model.username
            let country = model.address.country
            let provice = model.address.province
            let city = model.address.city
            guard avatar.count > 0 else { return false }
            guard country.count > 0 else { return false }
            guard username.count > 0 else { return false }
            if country.contains("中国") {
                guard provice.count > 0 else { return false }
                guard city.count > 0 else { return false }
            }
        }
        if step == 3 {
            let college = model.college
            guard college.count > 0 else { return false }
        }
        if step == 4 {
            let position = model.position
            let industry = model.industry
            guard position.count > 0 else { return false }
            guard industry.count > 0 else { return false }

        }
        return true
    }
}
