//
//  CGFloat+Extention.swift
//  galaxy
//
//  Created by EDY on 2024/8/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

extension CGFloat {
    var fix: CGFloat {
        let screenWidth = UIScreen.main.bounds.width
        // 假设设计稿基于375pt宽度，iPhone 6的屏幕宽度
        let baseWidth: CGFloat = 375.0
        // 计算换算比例
        let scale = screenWidth / baseWidth
        // 应用换算比例
        return self * scale
    }
}

extension Int {
    var fix: CGFloat {
        let screenWidth = UIScreen.main.bounds.width
        // 假设设计稿基于375pt宽度，iPhone 6的屏幕宽度
        let baseWidth: CGFloat = 375.0
        // 计算换算比例
        let scale = screenWidth / baseWidth
        // 应用换算比例
        return CGFloat(self) * scale
    }
}

extension Float {
    var fix: CGFloat {
        let screenWidth = UIScreen.main.bounds.width
        // 假设设计稿基于375pt宽度，iPhone 6的屏幕宽度
        let baseWidth: CGFloat = 375.0
        // 计算换算比例
        let scale = screenWidth / baseWidth
        // 应用换算比例
        return CGFloat(self) * scale
    }
}

extension Double {
    var fix: CGFloat {
        let screenWidth = UIScreen.main.bounds.width
        // 假设设计稿基于375pt宽度，iPhone 6的屏幕宽度
        let baseWidth: CGFloat = 375.0
        // 计算换算比例
        let scale = screenWidth / baseWidth
        // 应用换算比例
        return CGFloat(self) * scale
    }
}

