//
//  UINavigationController+Extension.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation
extension UINavigationController {
    /// remove spacial UIViewController
    ///
    /// - Parameter aClass: UIViewController Class
    func removeViewController(_ aClass: AnyClass) {
        viewControllers.removeAll(where: { $0.isKind(of: aClass) })
    }
    
    
    /// Push a UIViewController and remove a UIViewController class in the current stack when the push animation finished
    /// - Parameters:
    ///   - controller: A UIViewController instance that will be pushed
    ///   - removeClass: The UIViewController class that needs to be removed, default is nil
    func push(_ controller: UIViewController, removeClass: AnyClass? = nil) {
        CATransaction.setCompletionBlock { [unowned self] in
            // 移除栈中的当前Controller
            if let removeClass = removeClass {
                self.navigationController?.removeViewController(removeClass)
            }
        }
        CATransaction.begin()
        pushViewController(controller, animated: true)
        CATransaction.commit()
    }
}
