//
//  YHRangeDatePickerSheetView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHRangeDatePickerSheetView: UIView {
    static let contentViewH : CGFloat = (16 + 24) + (12 + 1) + (12 + 32) + YHRangeDatePickerView.viewH + 98
    
    typealias Block = (Date,Date) -> ()
    var block: Block?
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0x0F1214, alpha: 0.5)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    
    lazy var titleLable: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_B(ofSize:17)
        label.text = "选择意向赴港时间"
        label.textAlignment = .center
        return label
    }()
    
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    
    lazy var bottomView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        view.addSubview(self.rewardBtn)
        self.rewardBtn.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(10)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(44)
        }
        view.layer.zPosition = 10
        return view
    }()
    
    //知道了
    lazy var rewardBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("确定", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(clickSureBtn), for: .touchUpInside)
        button.backgroundColor = UIColor.brandMainColor
        return button
    }()
    
    
    lazy var closeBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
        
        button.setImage(UIImage(named: "work_example_close"), for: .normal)
        button.setImage(UIImage(named: "work_example_close"), for: .selected)
        return button
    }()
    
    lazy var datePickView : YHRangeDatePickerView = {
        let view = YHRangeDatePickerView()
        return view
    }()
    
    
    lazy var warnImageV: UIImageView = {
        let imageV  = UIImageView()
        imageV.image = UIImage(named: "appoint_warm_date_picker")
        imageV.contentMode = .scaleToFill
        imageV.clipsToBounds = true
        return imageV
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
}

extension YHRangeDatePickerSheetView  {
    
    static func sheetView() -> YHRangeDatePickerSheetView {
        let view = YHRangeDatePickerSheetView(frame:UIScreen.main.bounds)
        return view
    }
    
    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
        
        UIView.animate(withDuration: 0.5) {
            let whiteHeight = YHRangeDatePickerSheetView.contentViewH
            self.whiteContentView.frame = CGRect(x: 0, y: KScreenHeight - whiteHeight, width: KScreenWidth, height: whiteHeight)
        }
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func clickSureBtn() {
        if isChooseOk() {
            
            if let date1 = datePickView.startDate,let date2 = datePickView.endDate {
                self.block?(date1,date2)
            }
            dismiss()
        } else {
            YHHUD.flash(message: "选择开始/结束日期")
        }
    }
    
    
    func isChooseOk()->Bool {
        
        if datePickView.startDate != nil,datePickView.endDate != nil {
            
            
            return true
        }
        
        return false
    }
}

private extension YHRangeDatePickerSheetView {
    
    func setupUI() {
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)

        let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
        let path = UIBezierPath(roundedRect:bounds,byRoundingCorners: corner,cornerRadii:CGSizeMake(kCornerRadius6, kCornerRadius6));
        let layer = CAShapeLayer();
        layer.frame = whiteContentView.bounds;
        layer.path = path.cgPath;
        whiteContentView.layer.mask = layer;
        whiteContentView.clipsToBounds = true
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        let whiteHeight = YHHKCardTemplateView.contentViewH
        whiteContentView.frame = CGRect(x: 0, y: KScreenHeight, width: KScreenWidth, height: whiteHeight)
        
        whiteContentView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(98)
        }
        
        
        whiteContentView.addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(24)
        }
        
        
        whiteContentView.addSubview(closeBtn)
        closeBtn.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-21)
            make.height.width.equalTo(24)
            make.centerY.equalTo(titleLable.snp.centerY)
        }
        
        whiteContentView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.top.equalTo(titleLable.snp.bottom).offset(12)
            make.left.equalToSuperview().offset(21)
            make.right.equalToSuperview().offset(-21)
            make.height.equalTo(1)
        }
        
        
        whiteContentView.addSubview(warnImageV)
        warnImageV.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(12)
            make.centerX.equalToSuperview()
            make.width.equalTo(343)
            make.height.equalTo(32)
        }
        
        
        whiteContentView.addSubview(datePickView)
        datePickView.snp.makeConstraints { make in
            make.top.equalTo(warnImageV.snp.bottom)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHRangeDatePickerView.viewH)
        }
    }
}
