//
//  YHButlerServiceMessageHandler.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/6.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHButlerServiceMessageHandler: NSObject {
    // MARK: - 七鱼消息处理
    
    /// 七鱼消息转成银河需要的类型
    static func handleSessionMessage(sessionMessage: QYSessionInfo) -> YHButlerServiceMessage {
        // 列表： 暂无消息
        // 首页： 您有一条新的消息
        let nimMessage = sessionMessage.lastMessage // 网易云信消息
        let retMessage = YHButlerServiceMessage()
        retMessage.content = getContent(type: sessionMessage.lastMessageType, originalText: sessionMessage.lastMessageText, nimMessage: nimMessage) ?? ""
        retMessage.id = nimMessage?.messageId ?? ""
        retMessage.timeStamp = sessionMessage.lastMessageTimeStamp
        retMessage.isRead = nimMessage?.status == .read
        return retMessage
    }
}

extension YHButlerServiceMessageHandler {
    // MARK: - 私有方法
    
    /// 消息内容简单处理
    static private func getContent(type: QYMessageType, originalText: String?, nimMessage: NIMMessage?) -> String? {
        var text: String = ""
        switch type {
        case .audio:
            text = "[语音]"
            if let audioMessage = nimMessage?.messageObject as? NIMAudioObject {
                let duration = audioMessage.duration
                if duration > 0 {
                    let seconds = (duration + 999) / 1000
                    text += "\(seconds)″"
                }
            }
        case .text:
            text = originalText ?? ""
        case .image:
            text = "[图片]"
        case .video:
            text = "[视频]"
        case .file:
            text = "[文件]"
        case .custom:
            text = originalText ?? ""
        @unknown default:
            text = originalText ?? ""
        }
        return text
    }
}
