//
//  YHAdopterAddNewTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterAddNewTableViewCell: UITableViewCell {
    typealias ExperienceListBlock = (_ model: YHAdopterDependentModel) -> ()
    typealias IsMoreBlock = (_ isMore: Bool) -> ()
    typealias NewAdopterBlock = () -> ()
    var clickBlock: ExperienceListBlock?
    var deleteBlock: ExperienceListBlock?
    var isMoreBlock: IsMoreBlock?
    var newAdopterBlock: NewAdopterBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var cannalButton: UIButton!
    var moreButton: UIButton!
    var mainItemView: UIView!
    var lineView: UIView!
    var bottomView: YHWorkItemAddView!
    var showPrompt: Bool = false
    var dataSource: [YHAdopterDependentModel]?{
        didSet {
            updateAllViews()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(14)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.text = "新增受养人"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(23)
            make.height.equalTo(24)
            make.right.equalTo(-20)
        }
        
        cannalButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("取消操作", for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.addTarget(self, action: #selector(cannal), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        centerView.addSubview(cannalButton)
        cannalButton.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.top.equalTo(24)
            make.height.equalTo(20)
            make.width.equalTo(60)
        }
        
        moreButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "work_more"), for: .normal)
            button.addTarget(self, action: #selector(more), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(moreButton)
        moreButton.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.top.equalTo(24)
            make.height.equalTo(24)
            make.width.equalTo(24)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(62.5)
            make.height.equalTo(0.5)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-63)
            make.top.equalTo(63)
        }
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("新增受养人".local, for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.newAdopterBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.bottom.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(45)
        }
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        guard let dataSource = dataSource else {
            return
        }
        var total = 0
        for i in 0 ..< dataSource.count {
            if i != 0 {
                let line = UIView()
                line.backgroundColor = UIColor.separatorColor
                mainItemView.addSubview(line)
                line.snp.makeConstraints { make in
                    make.left.equalTo(18)
                    make.top.equalTo(total)
                    make.height.equalTo(0.5)
                    make.right.equalTo(-18)
                }
            }
            total = total + 1
            let itemView = YHAdopterItemView()
            itemView.clickBlock = {[weak self] model in
                guard let self = self else { return }
                if let block = self.clickBlock {
                    block(model)
                }
            }
            
            itemView.deleteBlock = {[weak self] model in
                guard let self = self else { return }
                if let block = self.deleteBlock {
                    block(model)
                }
            }
            let model = dataSource[i]
            itemView.tag = 4000 + i
            itemView.dataSource = dataSource[i]
            itemView.showPrompt = showPrompt
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(total)
                make.height.equalTo(51)
                make.right.equalTo(-18)
            }
            total = total + 51
        }
    }
    
    @objc func cannal() {
        moreButton.isHidden = false
        cannalButton.isHidden = true
        if dataSource?.count == 0 {
            moreButton.isHidden = true
            cannalButton.isHidden = true
        }
        for i in 0..<(dataSource?.count ?? 0) {
            let view = mainItemView.viewWithTag(4000 + i) as! YHAdopterItemView
            view.isShowDelete(i, isShow: false)
        }
        if let block = isMoreBlock {
            block(false)
        }
    }
    
    @objc func more() {
        moreButton.isHidden = true
        cannalButton.isHidden = false
        if dataSource?.count == 0 {
            moreButton.isHidden = true
            cannalButton.isHidden = true
        }
        for i in 0..<(dataSource?.count ?? 0) {
            let view = mainItemView.viewWithTag(4000 + i) as! YHAdopterItemView
            view.isShowDelete(i, isShow: true)
        }
        if let block = isMoreBlock {
            block(true)
        }
    }
}
