//
//  YHAdopterCardTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHAdopterCardTableViewCell: UITableViewCell {
    typealias ClicktBlock = (_ model: Int) -> ()
    var clickBlock: ClicktBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var selectLabel: UILabel!
    var moreButton: UIButton!
    var isShowRed: Bool = false
    var dataSource: YHAdopterDependentDataDocModel? {
        didSet {
            updateContent()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "主申请人资料"
            label.numberOfLines = 0
            let str = "* " + "受养人信息核实"
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_M(ofSize: 17),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 1)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            label.attributedText = questionAttrStr
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalToSuperview()
            make.bottom.equalToSuperview()
            make.right.equalTo(-80)
        }
        
        selectLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.numberOfLines = 0
            let a: ASAttributedString = .init("温馨提示：", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor50))
            let b: ASAttributedString = .init("存款证明有效期为3个月", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.brandMainColor))
            let c: ASAttributedString = .init("，并且存款金额为每个成员（包括额外新增受养人）", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor50))
            let d: ASAttributedString = .init("最低为12万", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.brandMainColor))
            label.attributed.text = a + b + c + d
            return label
        }()
        centerView.addSubview(selectLabel)
        selectLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(titleLabel.snp.bottom).offset(6)
            make.right.equalTo(-20)
        }
        
        moreButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
            button.contentHorizontalAlignment = .center
            button.setTitle("待上传", for: .normal)
            button.setImage(UIImage(named: "service_adopter_income_start"), for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.addTarget(self, action: #selector(more), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(moreButton)
        moreButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-14)
            make.height.equalTo(20)
            make.width.equalTo(62)
        }

        moreButton.iconInRight(with: 1)
    }
    
    @objc func more() {
        if let block = clickBlock {
            block(0)
        }
    }
    
    func updateContent() {
        guard let data = dataSource else { return }
        if data.require == 1 {
            let str = "* " + data.dep_name
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_M(ofSize: 16),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 2)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            titleLabel.attributedText = questionAttrStr
        } else {
            titleLabel.text = data.dep_name
        }
        
        if data.dep_type == 1 {
            let a: ASAttributedString = .init("如有", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.mainTextColor50))
            let b: ASAttributedString = .init("中国身份证", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.brandMainColor))
            let c: ASAttributedString = .init("，需要供用做证明", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor50))
            selectLabel.attributed.text = a + b + c
            titleLabel.snp.remakeConstraints { make in
                make.left.equalTo(20)
                make.top.equalTo(14)
                make.height.equalTo(22)
                make.right.equalTo(-18)
            }
        } else if data.dep_type == 2 {
            let a: ASAttributedString = .init("如曾更名，需要供用做证明", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.mainTextColor50))
            selectLabel.attributed.text = a
            titleLabel.snp.remakeConstraints { make in
                make.left.equalTo(20)
                make.top.equalTo(14)
                make.height.equalTo(22)
                make.right.equalTo(-18)
            }
        } else {
            let a: ASAttributedString = .init("", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.mainTextColor50))
            selectLabel.attributed.text = a
            titleLabel.snp.remakeConstraints { make in
                make.left.equalTo(20)
                make.top.equalToSuperview()
                make.bottom.equalToSuperview()
                make.right.equalTo(-80)
            }
        }
        
        if data.status == 0 {
            moreButton.setTitle("待上传", for: .normal)
            moreButton.setTitleColor(UIColor.brandMainColor, for: .normal)
            moreButton.setImage(UIImage(named: "service_adopter_income_start"), for: .normal)
        }
        if data.status == 1 {
            moreButton.setTitle("审核中", for: .normal)
            moreButton.setTitleColor(UIColor(hex: 0xff8000), for: .normal)
            moreButton.setImage(UIImage(named: "service_adopter_income_wait"), for: .normal)
        }
        if data.status == 2 {
            moreButton.setTitle("已驳回", for: .normal)
            moreButton.setTitleColor(UIColor.failColor, for: .normal)
            moreButton.setImage(UIImage(named: "service_adopter_income_fail"), for: .normal)
        }
        if data.status == 3 {
            moreButton.setTitle("已完成", for: .normal)
            moreButton.setTitleColor(UIColor(hex: 0x3cc694), for: .normal)
            moreButton.setImage(UIImage(named: "service_adopter_income_success"), for: .normal)
        }
        
        if isShowRed && (data.status == 0 || data.status == 2) && data.require == 1 {
            let a: ASAttributedString = .init("请上传\(data.dep_name)", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.failColor))
            selectLabel.attributed.text = a
            titleLabel.snp.remakeConstraints { make in
                make.left.equalTo(20)
                make.top.equalTo(20)
                make.height.equalTo(22)
                make.right.equalTo(-80)
            }
        }
    }
}
