//
//  YHAdopterItemView.swift
//  galaxy
//
//  Created by EDY on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterItemView: UIView {
    typealias ItemBlock = (_ model: YHAdopterDependentModel) -> ()
    var clickBlock: ItemBlock?
    var deleteBlock: ItemBlock?
    var titleLabel: UILabel!
    var explainLabel: UILabel!
    var nextStepImageView: UIImageView!
    var deleteButton: UIButton!
    var centerButton: UIButton!
    var showPrompt: Bool = false

    var dataSource: YHAdopterDependentModel? {
        didSet {
            updateAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_B(ofSize: 14)
            label.textAlignment = .left
            label.numberOfLines = 2
            label.textColor = UIColor.mainTextColor
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
            make.right.equalTo(-30)
        }
        
        explainLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textAlignment = .right
            label.textColor = UIColor.labelTextColor2
            return label
        }()
        addSubview(explainLabel)
        explainLabel.snp.makeConstraints { make in
            make.right.equalTo(-24)
            make.left.equalToSuperview()
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
        nextStepImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "form_right_arrow")
            return imageView
        }()
        addSubview(nextStepImageView)
        nextStepImageView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalTo(explainLabel.snp.centerY)
            make.height.width.equalTo(20)
        }
        
        centerButton = {
            let button = UIButton(type: .custom)
            button.addTarget(self, action: #selector(centerClick), for: .touchUpInside)
            return button
        }()
        addSubview(centerButton)
        centerButton.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(112)
        }
        
        deleteButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("删除", for: .normal)
            button.contentHorizontalAlignment = .right
            button.setTitleColor(UIColor.failColor, for: .normal)
            button.addTarget(self, action: #selector(deleteClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        addSubview(deleteButton)
        deleteButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(35)
            make.centerY.equalTo(titleLabel.snp.centerY)
        }
        
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        var spouse = "子女"
        if dataSource.is_spouse == 1 {
            spouse = "配偶"
        }
        if dataSource.dep_name.count != 0 {
            titleLabel.text = spouse + "(\(dataSource.dep_name))"
        } else {
            titleLabel.text = spouse
        }
        if dataSource.status == 0 {
            explainLabel.text = "待完善"
            explainLabel.textColor = UIColor.brandMainColor
            nextStepImageView.image = UIImage(named: "service_adopter_income_start")
        }
        if dataSource.status == 1 {
            explainLabel.text = "审核中"
            explainLabel.textColor = UIColor(hex: 0xff8000)
            nextStepImageView.image = UIImage(named: "service_adopter_income_wait")
        }
        if dataSource.status == 2 {
            explainLabel.text = "已驳回"
            explainLabel.textColor = UIColor.failColor
            nextStepImageView.image = UIImage(named: "service_adopter_income_fail")
        }
        if dataSource.status == 3 {
            explainLabel.text = "已完成"
            explainLabel.textColor = UIColor(hex: 0x3cc694)
            nextStepImageView.image = UIImage(named: "service_adopter_income_success")

        }
    }
    
    
    @objc func centerClick() {
        if let block = clickBlock {
            block(self.dataSource ?? YHAdopterDependentModel())
        }
    }
    
    @objc func deleteClick() {
        if let block = deleteBlock {
            block(self.dataSource ?? YHAdopterDependentModel())
        }
    }
    
    func isShowDelete(_ index: Int, isShow: Bool) {
        if isShow {
            explainLabel.isHidden = true
            nextStepImageView.isHidden = true
            deleteButton.isHidden = false
        } else {
            explainLabel.isHidden = false
            nextStepImageView.isHidden = false
            deleteButton.isHidden = true
        }
    }
}
