//
//  YHAdopterUploadTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterUploadTableViewCell: UITableViewCell {
    typealias NewFileBlock = () -> ()
    var newFileBlock: NewFileBlock?
    var bottomView: YHWorkItemAddView!

    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("上传".local, for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.newFileBlock {
                    block()
                }
            }
            return view
        }()
        contentView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(45)
            make.bottom.equalToSuperview()
        }
    }
}
