//
//  YHUploadCertificateDetailCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHUploadCertificateDetailCell: UITableViewCell {

    static let cellReuseIdentifier = "YHUploadCertificateDetailCell"
    static let cellH : CGFloat = 69.0
    
    var dataModel : YHUploadCertificateModel? {
        didSet {
            updataUI()
        }
    }

    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    
    lazy var titleLable: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_M(ofSize:14)
        label.text = "马尔扎哈"
        return label
    }()
    
    
    lazy var statusLable: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.brandMainColor
        label.font = UIFont.PFSC_R(ofSize:14)
        label.text = "待上传"
        return label
    }()
    
    
    lazy var statusImageView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "blue_right_arrow"))
        return view
    }()
    
    
    
    var isLastCell : Bool = false {
        didSet {
            updateCell()
        }
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
}

private extension YHUploadCertificateDetailCell {
    func updataUI() {
        guard let model = dataModel else { return }
        
        titleLable.text = model.apply_name
        
        //状态 1-已上传 2-未上传
        if model.status == 1 {
            statusLable.text = "已上传"
            statusLable.textColor = UIColor.successColor
            statusImageView.image = UIImage(named: "green_right_arrow")
            
        } else {
            statusLable.text = "待上传"
            statusLable.textColor = UIColor.brandMainColor
            statusImageView.image = UIImage(named: "blue_right_arrow")
        }
    }
    
    func updateCell() {
        if isLastCell {
            let corner = UIRectCorner(rawValue: UIRectCorner.bottomLeft.rawValue | UIRectCorner.bottomRight.rawValue)
            let path = UIBezierPath(roundedRect:bounds,byRoundingCorners: corner,cornerRadii:CGSizeMake(kCornerRadius6, kCornerRadius6))
            let layer = CAShapeLayer()
            layer.frame = whiteContentView.bounds;
            layer.path = path.cgPath;
            whiteContentView.layer.mask = layer
            whiteContentView.clipsToBounds = true
            
            lineView.isHidden = true
        } else {
            whiteContentView.layer.mask = nil
            lineView.isHidden = false
        }
    }
    
    func setupUI() {
        
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        
        whiteContentView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        
        whiteContentView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(1)
        }
        
        whiteContentView.addSubview(statusImageView)
        statusImageView.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.width.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
        
        whiteContentView.addSubview(statusLable)
        statusLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(statusImageView.snp.left)
            make.height.equalTo(20)
        }
        
        whiteContentView.addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.height.equalTo(20)
        }
    }
}
