//
//  YHPayMemberItemsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString


class YHPayMemberItemsView: UIView {
    
    var dataModel : YHVisaPaymentModel? {
        didSet {
            updateUI()
        }
    }
    
    var isLastFlag : Bool = false {
        didSet {
            lineView.isHidden = isLastFlag
        }
    }
    
    lazy var sectionItem: YHPayMemberSectionItem = {
        let view = YHPayMemberSectionItem()
        return view
    }()
    
    lazy var contentItems: YHPayMemberContentItems = {
        let view = YHPayMemberContentItems()
        return view
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        view.isHidden = true
        return view
    }()
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

private extension YHPayMemberItemsView {
    func setupUI() {
//        updateUI()
    }
}


extension YHPayMemberItemsView {
    func updateUI() {
        
        guard let model = dataModel else { return }
        
        removeSubviews()
        
        addSubview(sectionItem)
        sectionItem.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(YHPayMemberSectionItem.viewH)
        }
        sectionItem.dataModel = model
        
        
        addSubview(contentItems)
        contentItems.snp.makeConstraints { make in
            make.top.equalTo(sectionItem.snp.bottom).offset(kMargin)
            make.left.equalToSuperview()
            make.right.equalToSuperview()
        }
        contentItems.dataModel = model
        
        addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.top.equalTo(contentItems.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
            make.bottom.equalToSuperview()
        }
    }
}
