//
//  YHVisaPaymentViewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit


class YHVisaPaymentViewModel: YHBaseViewModel {
    //电子签字列表
    var visaPaymentData : YHVisaPaymentListModel?
    
    //更新状态
    var updateStatusModel : YHVisaPaymentUpdateStatusModel = YHVisaPaymentUpdateStatusModel()
}

//请求接口
extension YHVisaPaymentViewModel {
    //判断全部用户 都已经支付
    func isAllMemberPay() -> Bool {
        var flag = true
        guard let model = visaPaymentData else { return flag }

        for(index,item) in model.list.enumerated() {
            if item.pay_status == 7 {
                flag = false
            }
        }
        return flag
    }
    
    //电子签字缴费列表
    func getVisaPaymentList(_ params: [String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.VisaPayment.paymentListApi
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let resultModel = YHVisaPaymentListModel.deserialize(from: dic) else {
                    callBackBlock(false,nil)
                    return
                }
                self.visaPaymentData = resultModel
                callBackBlock(true,nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    //发送 支付结果查询
    func postPaymentResult(_ params: [String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.VisaPayment.paymentResultApi
        let _ = YHNetRequest.postRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    //查询更新状态
    func getPaymentUpdateStatus(_ params: [String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.VisaPayment.paymentUpdateApi
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let resultModel = YHVisaPaymentUpdateStatusModel.deserialize(from: dic) else {
                    callBackBlock(false,nil)
                    return
                }
                self.updateStatusModel = resultModel
                callBackBlock(true,nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
}
