//
//  YHOffivialApprovalSuccessView.swift
//  galaxy
//
//  Created by EDY on 2024/8/9.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOffivialApprovalSuccessView: UIView {
    
    var dataModel : YHOfficalLetterListModel? {
        didSet {
            updateUI()
        }
    }

    private var titleLabel: UILabel!
    
    private var arrViews : [UIView] = []
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }

    func setupUI() {
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 30)
            label.textColor = UIColor(hex: 0x881000)
            label.text = "恭喜 客户！"
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(5)
            make.top.equalTo(0)
            make.right.equalTo(-5)
            make.height.equalTo(42.fix)
        }
    }
    
    func updataView(data: [String]) {
        
        for (_,item) in arrViews.enumerated() {
            item.removeFromSuperview()
        }
        
        var h = 60
        var index = 0
        for item in data {
            let label = UILabel()
            label.text = item
            label.font = UIFont.PFSC_M(ofSize: 15)
            label.textColor = UIColor(hex: 0x881000)
            if index == 2 {
                label.textColor = UIColor(hex: 0xd12501)
            }
            addSubview(label)
            label.snp.makeConstraints { make in
                make.left.equalTo(5.fix)
                make.top.equalTo(CGFloat(h).fix)
                make.right.equalTo(-5)
                make.height.equalTo(26.fix)
            }
            let line = UIView()
            line.backgroundColor = UIColor(hex: 0x881000).withAlphaComponent(0.15)
            addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(5)
                make.top.equalTo(CGFloat(h + 26 + 2).fix)
                make.width.equalTo(234.fix)
                make.height.equalTo(1)
            }
            h = h + 26 + 10
            index = index + 1
            
            arrViews.append(label)
            arrViews.append(line)
            
        }
    }
}

private extension YHOffivialApprovalSuccessView {
    func updateUI() {

        guard let model = dataModel else { return }
        titleLabel.text = "恭喜 " + model.applicant_name + model.applicant_sex.gentlemanDescribe() + "！"
        
        if model.applicant_approval_date.count >= "2023年10月1日".count {
            
            var tmp = model.applicant_approval_date.slice(from: 0, length: "2023年10月1日".count)
            let arr = tmp.split(separator: "-")
            if arr.count == 3 {
                tmp = arr[0] + "年" + arr[1] + "月" + arr[2] + "日" + "正式获批"
                let fourItems = ["祝贺您和您的家人申请的","【优秀人才入境计划】",tmp,"这意味着，您领取香港居民身份证","仅有一步之遥！！"]
                updataView(data: fourItems)
            }
        } else {
            titleLabel.text = "恭喜 客户！"
            let tmp = "正式获批"
            let fourItems = ["祝贺您和您的家人申请的","【优秀人才入境计划】",tmp,"这意味着，您领取香港居民身份证","仅有一步之遥！！"]
            updataView(data: fourItems)
            
        }
    }
}
