//
//  YHResinMaterialManageListVC.swift
//  galaxy
//
//  Created by edy on 2024/9/9.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHResinMaterialManageContainerVC: YHBaseViewController {
    
    static let segmentHeight = 40.0
    let viewModel = YHResignMaterialViewModel()
    var titles = ["全部", "待上传(0)", "已驳回(0)", "审核中(0)", "已完成(0)"]
    let itemVCs:[YHResignMaterialListVC] = [YHResignMaterialListVC(),
                                            YHResignMaterialListVC(),
                                            YHResignMaterialListVC(),
                                            YHResignMaterialListVC(),
                                            YHResignMaterialListVC()]

    //分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        return JXSegmentedListContainerView(dataSource: self, type: .collectionView)
    }()

    lazy var segmentedView : JXSegmentedView = {
        let segview = JXSegmentedView(frame: CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: KScreenWidth, height: Self.segmentHeight))
        segview.dataSource = segmentedDataSource
        segview.delegate = self
        //配置指示器
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorWidth = 16
        indicator.indicatorHeight = 2.0
        indicator.indicatorCornerRadius = 0.0
        indicator.indicatorColor = .brandMainColor
        segview.indicators = [indicator]
        segview.backgroundColor = .clear
        segview.listContainer = listContainerView
        segview.backgroundColor = .white
        return segview
    }()
    
    lazy var segmentContainerView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.isTitleColorGradientEnabled = true
        dataSource.titles = titles
        dataSource.titleNormalFont = UIFont.PFSC_R(ofSize: 14)
        dataSource.titleNormalColor = .yhGreyColor
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleSelectedColor = .mainTextColor
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.itemWidth = JXSegmentedViewAutomaticDimension
        dataSource.titleSelectedZoomScale = 1.0
        dataSource.itemSpacing = 16
        return dataSource
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        createUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        requestData()
    }
    
    func createUI() {
        
        self.gk_navTitle = "续签资料管理"
        self.view.backgroundColor = .white
        
        view.addSubview(segmentContainerView)
        segmentContainerView.addSubview(segmentedView)
        view.addSubview(listContainerView)
        
        segmentContainerView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(4.0)
            make.right.equalToSuperview().offset(-4)
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar)
            make.height.equalTo(Self.segmentHeight+4)
        }
        
        segmentedView.snp.makeConstraints { make in
            make.top.left.equalToSuperview()
            make.right.equalToSuperview()
            make.height.equalTo(Self.segmentHeight)
        }
    
        listContainerView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(segmentContainerView.snp.bottom)
            make.bottom.equalToSuperview()
        }
    }
    
    func requestData() {
        
        let params: [String : Any] = ["order_id" : 151336,
                                      "id" : 351]
        viewModel.getMaterialList(param: params) { success, error in
            for (index, vc) in self.itemVCs.enumerated() {
                if index == 0 {
                    vc.items = self.viewModel.allGroup.getDataArr()
                    
                } else if index == 1 {
                    vc.items = self.viewModel.preuploadGroup.getDataArr()
                
                } else if index == 2 {
                    vc.items = self.viewModel.rejectedGroup.getDataArr()
                
                } else if index == 3 {
                    vc.items = self.viewModel.reviewGroup.getDataArr()
                
                } else if index == 4 {
                    vc.items = self.viewModel.finishGroup.getDataArr()
                }
            }
            self.titles = ["全部",
                           "带上传(\(self.viewModel.preuploadGroup.getTotalCount()))",
                           "已驳回(\(self.viewModel.rejectedGroup.getTotalCount()))",
                           "审核中(\(self.viewModel.reviewGroup.getTotalCount()))",
                           "已完成(\(self.viewModel.finishGroup.getTotalCount()))",]
            self.segmentedDataSource.titles = self.titles
            self.segmentedView.reloadDataWithoutListContainer()
        }
    }
}

extension YHResinMaterialManageContainerVC: JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        
        if 0 <= index, index < itemVCs.count {
            return itemVCs[index]
        }
        return YHResignMaterialListVC()
    }
}

extension YHResinMaterialManageContainerVC: JXSegmentedViewDelegate {
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        if 0 <= index && index < itemVCs.count {
            let vc = itemVCs[index]
//            if index == 0 {
//                vc.requestList(status: vc.status, extra: self.filterDict)
//            } else {
//                vc.requestList(status: vc.status)
//            }
        }
    }
    /// 正在滚动中的回调
    ///
    /// - Parameters:
    ///   - segmentedView: JXSegmentedView
    ///   - leftIndex: 正在滚动中，相对位置处于左边的index
    ///   - rightIndex: 正在滚动中，相对位置处于右边的index
    ///   - percent: 从左往右计算的百分比
    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
        
    }
}
