//
//  YHEducationInfo.swift
//  galaxy
//
//  Created by edy on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHEducationListInfo: SmartCodable {
    var orderId: Int = 0
    var eduList: [YHEducationInfo]?
    var quaList: [YHQualificationInfo]?
    var isNameSame:Bool?
    var isSpouseNameSame:Bool?
    // 1=已婚,2=未婚,3=离婚,4=分居,5=丧偶,6=事实婚姻,7=鳏寡
    var married: Int = 0
    
    func isMarried() ->Bool {
        return married != 2
    }

    enum CodingKeys: String, CodingKey {
        case orderId = "order_id"
        case eduList = "edu_list"
        case quaList = "qua_list"
        case isNameSame = "is_name_same"
        case isSpouseNameSame = "is_spouse_name_same"
        case married = "married"
    }

    required init() {
        
    }
}

class YHEducationInfo: SmartCodable {
    var id: Int = 0
    var college: String?
    var major: String?
    var degree: String?
    var admissionTime: String?
    var graduateTime: String?
    var vacantNum: Int = 0

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case college = "college"
        case major = "major"
        case degree = "degree"
        case admissionTime = "admission_time"
        case graduateTime = "graduate_time"
        case vacantNum = "vacant_num"
    }
    
    required init() {
        
    }
}

class YHQualificationInfo: SmartCodable {
    var id: Int = 0
    var qualification: String?
    var vacantNum: Int = 0

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case qualification = "qualification"
        case vacantNum = "vacant_num"
    }

    required init() {
        
    }
}


class YHEducationDetailInfo: SmartCodable {
    
    var id: Int = 0
    var college: String = ""
    var teachingFormat: String = ""
    var admissionTime: String = ""
    var graduateTime: String = ""
    var degree: String = ""
    var major: String = ""
    var degreeType: String = ""
    var schoolAddress: YHCollegeAddress = YHCollegeAddress()
    var isAboardSchool: Bool = false
    
    enum CodingKeys: String, CodingKey {
        case id = "id"
        case college = "college"
        case teachingFormat = "teaching_format"
        case admissionTime = "admission_time"
        case graduateTime = "graduate_time"
        case degree = "degree"
        case major = "major"
        case degreeType = "degree_type"
        case schoolAddress = "school_address"
        case isAboardSchool = "is_aboard_school"
    }
    
    required init() {
        
    }
    // 学校是否在国外 默认是在国内
    func isSchoolInAboard() -> Bool {
        if schoolAddress.country.isEmpty { return false }
        if schoolAddress.country.contains("中国") {
            return false
        }
        return true
    }
}

class YHCollegeAddress: Codable {
   
    var area: [String] = []
    var country: String = ""
    var details: String = ""
    var foreign: String = ""

    enum CodingKeys: String, CodingKey {
        case area = "area"
        case country = "country"
        case details = "details"
        case foreign = "foreign"
    }

    required init() {
    
    }
}

class YHQualificationDetailInfo: SmartCodable {
        var id: Int = 0
        var certName: String = ""
        var issuingAgent: String = ""
        var issuingYear: Int = 0
        var issuingAddr: YHCollegeAddress = YHCollegeAddress()
        var isAboardAddr: Bool = false

        enum CodingKeys: String, CodingKey {
            case id = "id"
            case certName = "cert_name"
            case issuingAgent = "issuing_agent"
            case issuingYear = "issuing_year"
            case issuingAddr = "issuing_addr"
            case isAboardAddr = "is_aboard_addr"
        }
    
    // 学校是否在国外 默认是在国内
    func isCollegeInAboard() -> Bool {
        if issuingAddr.country.isEmpty { return false }
        if issuingAddr.country.contains("中国") {
            return false
        }
        return true
    }

    required init() {
        
    }
}

class YHCollegeInfo: SmartCodable {
    
    var id: Int = 0
    var zhName: String = ""
    var enName: String = ""
    // 0-未知，1-中文主校，2-英文主校
    var mainNameType: Int = 0
    var schoolType: Int = 0
    var assoProduct: [Int] = []
    var color: String = ""

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case zhName = "zh_name"
        case enName = "en_name"
        case mainNameType = "main_name_type"
        case schoolType = "school_type"
        case assoProduct = "asso_product"
        case color = "color"
    }
    
    func getCollegeName() -> String {
        if mainNameType == 1 {
            return zhName
            
        } else if mainNameType == 2 {
            return enName
        }
        if !zhName.isEmpty {
            return zhName
        }
        return enName
    }
    
    required init() {
        
    }
}



