//
//  YHEducationRequestViewModel.swift
//  galaxy
//
//  Created by edy on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHEducationRequestViewModel {
    // 学历和专业信息
    var listInfo: YHEducationListInfo?
    // 学历详情信息
    var educationDetailInfo: YHEducationDetailInfo?
    // 专业详情信息
    var qualificationDetailInfo: YHQualificationDetailInfo?
    // 搜索学校数组
    var collegeList: [YHCollegeInfo]?
    
    // 请求学历和专业证书信息列表
    func requestEducationInfoList(params:[String:Any], callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
       
       YHHUD.show(.progress(message: "数据加载中..."))

       let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Education.getEducationAndQulificationInfoListApi
       
       let _ = YHNetRequest.getRequest(url: strUrl, params:params) {[weak self] json, code in
           
           YHHUD.hide()
           guard let self = self else { return }
           printLog("model 是 ==> \(json)")
           
           if json.code == 200 {
               guard let dic = json.data?.peel as? [String : Any], let resultModel = YHEducationListInfo.deserialize(from: dic) else {
                   let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                   callBackBlock(false,error)
                   return
               }
               listInfo = resultModel
               callBackBlock(true,nil)
           } else {
               let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
               callBackBlock(false, error)
           }
           
       } failBlock: { err in
           YHHUD.hide()
           callBackBlock(false,err)
       }
   }
    
    // 获取学历详情
    func getEducationDetailInfo(params:[String:Any], callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        YHHUD.show(.progress(message: "数据加载中..."))

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Education.getEducationDetailInfoApi
        
        let _ = YHNetRequest.getRequest(url: strUrl, params:params) {[weak self] json, code in
            
            YHHUD.hide()
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let resultModel = YHEducationDetailInfo.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())

                    callBackBlock(false,error)
                    return
                }
                educationDetailInfo = resultModel
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false,error)

            }
            
        } failBlock: { err in
            YHHUD.hide()
            callBackBlock(false,err)
        }
    }
    
    // 保存学历
    func saveEducationInfo(params:[String:Any], isSilent:Bool, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        if !isSilent {
            YHHUD.show(.progress(message: "数据加载中..."))
        }

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Education.saveEducationInfoApi
        
        let _ = YHNetRequest.postRequest(url: strUrl, params:params) {[weak self] json, code in
            
            if !isSilent {
                YHHUD.hide()
            }
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                               callBackBlock(false,error)
                callBackBlock(false, error)
            }
            
        } failBlock: { err in
            if !isSilent {
                YHHUD.hide()
            }
            callBackBlock(false,err)
        }
    }
    
    // 删除学历
    func deleteEducationInfo(id:Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        YHHUD.show(.progress(message: "数据加载中..."))

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Education.deleteEducationInfoApi
        
        let _ = YHNetRequest.postRequest(url: strUrl, params:["id" : id]) {[weak self] json, code in
            
            YHHUD.hide()
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                               callBackBlock(false,error)
                callBackBlock(false, error)
            }
            
        } failBlock: { err in
            YHHUD.hide()
            callBackBlock(false,err)
        }
    }
    
    // 删除专业
    func deleteQualificationInfo(id:Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        YHHUD.show(.progress(message: "数据加载中..."))

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Qualification.deleteQualificationInfoApi
        
        let _ = YHNetRequest.postRequest(url: strUrl, params:["id" : id]) {[weak self] json, code in
            
            YHHUD.hide()
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                               callBackBlock(false,error)
                callBackBlock(false, error)
            }
            
        } failBlock: { err in
            YHHUD.hide()
            callBackBlock(false,err)
        }
    }
    
    // 保存所有
    func saveAllEducationInfo(params:[String:Any], callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        YHHUD.show(.progress(message: "数据加载中..."))

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Education.saveAllEduAndQuaInfoApi
        
        let _ = YHNetRequest.postRequest(url: strUrl, params:params) {[weak self] json, code in
            
            YHHUD.hide()
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                               callBackBlock(false,error)
                callBackBlock(false, error)
            }
            
        } failBlock: { err in
            YHHUD.hide()
            callBackBlock(false,err)
        }
    }
    
    // 获取专业详情
    func getQualificationDetailInfo(id:Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        YHHUD.show(.progress(message: "数据加载中..."))

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Qualification.getQualificationDetailInfoApi
        
        let _ = YHNetRequest.getRequest(url: strUrl, params:["id" : id]) {[weak self] json, code in
            
            YHHUD.hide()
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let quaDict = dic["qua_data"] as? [String : Any],let resultModel = YHQualificationDetailInfo.deserialize(from:quaDict) else {

                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false,error)

                    return
                }
                qualificationDetailInfo = resultModel
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                              callBackBlock(false,error)

            }

        } failBlock: { err in
            YHHUD.hide()
            callBackBlock(false,err)
        }
    }
    
    // 保存专业信息
    func saveQualificationInfo(params:[String:Any], isSilent:Bool, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        if !isSilent {
            YHHUD.show(.progress(message: "数据加载中..."))
        }

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Qualification.saveQualificationInfoApi
        
        let _ = YHNetRequest.postRequest(url: strUrl, params:params) {[weak self] json, code in
            
            if !isSilent {
                YHHUD.hide()
            }
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false,error)

            }
            
        } failBlock: { err in
            if !isSilent {
                YHHUD.hide()
            }
            callBackBlock(false,err)
        }
    }
    
    // 搜索学校
    func searchCollegeInfoList(params:[String:Any], callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
       
       let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Education.searchCollegeNameApi
       
       let _ = YHNetRequest.getRequest(url: strUrl, params:params) {[weak self] json, code in
           
           YHHUD.hide()
           guard let self = self else { return }
           printLog("model 是 ==> \(json)")
           
           if json.code == 200 {
               guard let dic = json.data?.peel as? [String : Any],let list = dic["list"] as? [[String:Any]], let results = [YHCollegeInfo].deserialize(from: list) as? [YHCollegeInfo] else {

                   let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                   callBackBlock(false,error)
                   return
               }
               collegeList = results
               callBackBlock(true,nil)
           } else {
               let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
               callBackBlock(false,error)

           }
           
           
       } failBlock: { err in
           YHHUD.hide()
           callBackBlock(false,err)
       }
   }
    
}
