//
//  YHSaveAndSubmitView.swift
//  galaxy
//
//  Created by edy on 2024/1/31.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSaveAndSubmitView: UIView {

    static let submitBtnHeight = 48.0
    static let saveBtnWidth = 86.0
    static let gap = 8.0
    static let height = submitBtnHeight+gap*2+k_Height_safeAreaInsetsBottom()
    
    var saveBlock:(()->Void)?
    var submitBlock:(()->Void)?
    // 是否隐藏保存按钮
    var isHiddenSave:Bool = false {
        didSet {
            self.saveBtn.isHidden = isHiddenSave
            self.saveBtn.snp.updateConstraints { make in
                make.width.equalTo(isHiddenSave ? 0 : Self.saveBtnWidth)
            }
            
            self.submitBtn.snp.updateConstraints { make in
                make.left.equalTo(saveBtn.snp.right).offset(isHiddenSave ? 0.0 : 10)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    // 是否隐藏提交按钮
    var isHiddenSubmit:Bool = false {
        didSet {
            self.submitBtn.isHidden = isHiddenSubmit
            
            if isHiddenSubmit {
                saveBtn.snp.remakeConstraints { make in
                    make.left.equalToSuperview().offset(16)
                    make.height.equalTo(Self.submitBtnHeight)
                    make.right.equalToSuperview().offset(-16)
                    make.top.equalTo(Self.gap)
                }
                
                submitBtn.snp.remakeConstraints { make in
                    make.width.equalTo(isHiddenSave ? 0 : Self.saveBtnWidth)
                    make.height.equalTo(Self.submitBtnHeight)
                    make.centerY.equalTo(saveBtn)
                    make.right.equalToSuperview()
                }
            } else {
                saveBtn.snp.remakeConstraints { make in
                    make.left.equalToSuperview().offset(16)
                    make.height.equalTo(Self.submitBtnHeight)
                    make.width.equalTo(Self.saveBtnWidth)
                    make.top.equalTo(Self.gap)
                }
                
                submitBtn.snp.remakeConstraints { make in
                    make.left.equalTo(saveBtn.snp.right).offset(10)
                    make.right.equalToSuperview().offset(-16)
                    make.height.equalTo(Self.submitBtnHeight)
                    make.centerY.equalTo(saveBtn)
                }
            }
            
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }

    lazy var submitBtn:UIButton = {
        let btn = UIButton()
        btn.setTitle("提交".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor.brandMainColor
        btn.layer.cornerRadius = kCornerRadius3
        btn.addTarget(self, action: #selector(didClickSubmitBtn), for: .touchUpInside)
        return btn
    }()
    
    lazy var saveBtn:UIButton = {
        let btn = UIButton()
        btn.setTitle("保存", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(UIColor.mainTextColor, for: .normal)
        btn.backgroundColor = UIColor(hexString:"#F8F9FB")
        btn.layer.cornerRadius = kCornerRadius3
        btn.addTarget(self, action: #selector(didClickSaveBtn), for: .touchUpInside)
        return btn
    }()
    
    lazy var bottomView:UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.addSubview(submitBtn)
        view.addSubview(saveBtn)
        return view
    }()
    
    static func createView() -> YHSaveAndSubmitView {
        
        let view = YHSaveAndSubmitView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: Self.height))
        return view
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.createUI()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    func createUI() {
        
        self.backgroundColor = .white
        
        self.addSubview(saveBtn)
        self.addSubview(submitBtn)
        
        saveBtn.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.height.equalTo(Self.submitBtnHeight)
            make.width.equalTo(Self.saveBtnWidth)
            make.top.equalTo(Self.gap)
        }
        
        submitBtn.snp.makeConstraints { make in
            make.left.equalTo(saveBtn.snp.right).offset(10)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(Self.submitBtnHeight)
            make.centerY.equalTo(saveBtn)
        }
    }
    
    func changeRightBtnTitle(_ title:String?) {
        submitBtn.setTitle(title, for: .normal)
    }
    
    @objc func didClickSubmitBtn() {
        if let submitBlock = submitBlock {
            submitBlock()
        }
    }
    
    @objc func didClickSaveBtn() {
        if let saveBlock = saveBlock {
            saveBlock()
        }
    }
}
