//
//  YHPreviewAcademicAndProfessionalQualificationViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 *学历/专业资格 预览
 */
class YHPreviewAcademicAndProfessionalQualificationViewController: YHPreviewBaseViewController {
    private let previewVM : YHPreviewViewModel =  YHPreviewViewModel()
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
}

private extension YHPreviewAcademicAndProfessionalQualificationViewController {
    func loadData() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
//            let tmp = 133967 //全数据 可测试
            previewVM.getPreviewForAcademicInfo(params: ["order_id" : orderID]) { success, error in
                if success == true {
                    
                } else {
                    
                }
                self.homeTableView.reloadData()
            }
        } else {
            printLog("error : orderID 为空")
        }
    }
    func setupUI() {
        self.homeTableView.register(YHPreviewInfoCell.self,forCellReuseIdentifier: YHPreviewInfoCell.cellReuseIdentifier)
        self.homeTableView.reloadData()
    }
}

// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHPreviewAcademicAndProfessionalQualificationViewController {
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return previewVM.arrDataForAcademicInfo.count
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHPreviewInfoCell.self)
        cell.selectionStyle = .none
        cell.model = previewVM.arrDataForAcademicInfo[indexPath.row]
        return cell
    }
}
