//
//  YHPreviewViewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/3.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewViewModel: YHBaseViewModel {
    //工作经验
    var workExpInfoPreviewModel : YHWorkExpInfoPreviewModel?
    var arrDataForWorkExpInfo : [YHPreviewInfoSessionModel] = []
    
    //学历/专业资格
    var academicInfoPreviewModel : YHAcademicPreviewModel?
    var arrDataForAcademicInfo : [YHPreviewInfoSessionModel] = []
    
    //家庭成员信息 预览
    var familyInfoPreviewModel : YHFamilyMemberGroupInfo?
    var arrDataForFamilyInfo : [YHPreviewInfoSessionModel] = [] //用于展示
    var arrDataForParents : [YHPreviewInfoSessionModel] = []//父亲
    var arrDataForSpouse : [YHPreviewInfoSessionModel] = []//配偶
    var arrDataForChildren : [YHPreviewInfoSessionModel] = []//子女
    var arrDataForBrother : [YHPreviewInfoSessionModel] = []//兄弟姐妹
    
    
    //主申请人信息 预览
    var mainApplicationInfoPreviewModel : YHMainInfoPreviewModel?
    var arrDataForMainApplicationInfo : [YHPreviewInfoSessionModel] = []
    
    //其他信息 预览
    private var otherInfoPreviewModel : YHPreviewForOtherInfoModel?
    var arrDataForOtherInfo : [YHPreviewInfoSessionModel] = []
    
    //基本资料 预览
    private var basiceInfoPreviewModel : YHBasicInfoFillModel?
    var arrDataForBasicInfo : [YHPreviewInfoSessionModel] = []
}

extension YHPreviewViewModel {
    
    //工作经验 预览
    func getPreviewForWorkExpInfo(params:[String:Any], callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewWorkExpInfoApi
        let _ = YHNetRequest.getRequest(url: strUrl, params:params) {[weak self] json, code in
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let resultModel = YHWorkExpInfoPreviewModel.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false,error)
                    return
                }
                workExpInfoPreviewModel = resultModel
                installDataForWorkExpInfo()
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false,error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    
    //获取学历/专业 预览数据
    func getPreviewForAcademicInfo(params:[String:Any], callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewAcademicAndProfessionalQualificationInfoApi
        let _ = YHNetRequest.getRequest(url: strUrl, params:params) {[weak self] json, code in
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let resultModel = YHAcademicPreviewModel.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false,error)
                    return
                }
                academicInfoPreviewModel = resultModel
                installDataForAcademicInfo()
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false,error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    
    
    //获取家庭成员 预览数据
    func getPreviewForFamilyInfo(params:[String:Any], callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewFamilyInfoApi
        let _ = YHNetRequest.getRequest(url: strUrl, params:params) {[weak self] json, code in
            YHHUD.hide()
            
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let resultModel = YHFamilyMemberGroupInfo.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false,error)
                    return
                }
                familyInfoPreviewModel = resultModel
                installDataForFamilyInfo()
                callBackBlock(true,nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false,error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    //获取主申请人 预览数据
    func getPreviewForMainApplicationInfo( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewMainApplicationInfoApi
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            
            arrDataForMainApplicationInfo.removeAll()
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let result = YHMainInfoPreviewModel.deserialize(from: dic) else {
                    callBackBlock(false,nil)
                    return
                }
                self.mainApplicationInfoPreviewModel = result
                installDataForMainApplicationInfo()
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    
    //获取基本资料预览 数据
    func getPreviewForBasicInfo( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewBasicInfoApi
        
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let resultModel = YHBasicInfoFillModel.deserialize(from: dic) else {
                    callBackBlock(false,nil)
                    return
                }
                
                self.basiceInfoPreviewModel = resultModel
                //根据返回值 组装 真实的数据
                installDataForBasicInfo()
                
                callBackBlock(true,nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code),errorMsg: json.msg)
                callBackBlock(false,error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    
    //获取其他信息预览 数据
    func getPreviewForOtherInfo( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewOtherInfoApi
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let resultModel = YHPreviewForOtherInfoModel.deserialize(from: dic) else {
                    callBackBlock(false,nil)
                    return
                }
                self.otherInfoPreviewModel = resultModel
                installDataForOtherInfo()
                //根据返回值 组装 真实的数据
                callBackBlock(true,nil)
                
            } else {
                let err : YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
}
private extension YHPreviewViewModel {
    //组装 工作经验 数据
    func installDataForWorkExpInfo() {
        guard let model0 = workExpInfoPreviewModel else { return}
        arrDataForWorkExpInfo.removeAll()
        if let list = model0.list,list.isEmpty == false {
            
            for(index,model) in list.enumerated() {
                var arr1 : [YHPreviewQuestionAndAnswerModel] = []
                do {
                    //1.基本信息
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "用人单位：", answer: model.company_name)
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "用人单位性质：", answer: model.industry)
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "用人单位介绍：", answer: model.company_introduce.defaultStringIfEmpty())
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "用人单位官网：", answer: model.company_website.defaultStringIfEmpty())
                    var title = "-"
                    if let item = model.location {
//                        title = item.country + "-"  + item.details
                        if item.country.contains("中国") {
                            title = "国内 "
                            if item.area.count > 1 {
                                title = title + item.area[0] + "/" + item.area[1]
                            }
                        } else {
                            title = "国外 " + item.country + "-" + item.foreign
                        }
                    }
                    
                    
                    
                    
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "工作地点：", answer: title)
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "职位：", answer: model.position)
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "入职年月：", answer: model.entry_time)
                    let tmp8 = YHPreviewQuestionAndAnswerModel(question: "离职年月：", answer: model.departure_time)
                    let tmp9 = YHPreviewQuestionAndAnswerModel(question: "工作证明文件：", answer: model.work_certificate)
                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "职责性质：", answer: model.duty)
                    title = model.international_work_experience == 0 ? "否" : "是"
                    let tmp11 = YHPreviewQuestionAndAnswerModel(question: "相关工作是否属国际工作经验：", answer:title)
                    let tmp12 = YHPreviewQuestionAndAnswerModel(question: "企业人数规模：", answer:String(model.company_member_total))
                    
                    let tempppp = YHConstantArrayData.getShowNameBy(indexStr: String(model.administrative_level), type: .structure)
                    let tmp13 = YHPreviewQuestionAndAnswerModel(question: "行政架构层级：", answer:tempppp)
                    let tmp14 = YHPreviewQuestionAndAnswerModel(question: "下属管理人数：", answer:String(model.company_manage_total))
                    
                    var ttt = ""
                    if model.turnover == 0 {
                        ttt = "0"
                    } else {
                        ttt = String(model.turnover).defaultStringIfEmpty()
                    }
                    let tmp15 = YHPreviewQuestionAndAnswerModel(question: "公司营业额/港元(近一年)：", answer:ttt)
                    
                    let tempppp0 = YHConstantArrayData.getShowNameBy(indexStr: String(model.professional_level), type: .level)
                    let tmp16 = YHPreviewQuestionAndAnswerModel(question: "职业水平类别：", answer:tempppp0)
                    arr1.append(contentsOf: [tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,tmp7,tmp8,tmp9,tmp10,tmp11,tmp12,tmp13,tmp14,tmp15,tmp16])
                }
                
                let dataModel1 = YHWorkExpDataModel(title: "", data: arr1)
                
                var arr2 : [YHPreviewQuestionAndAnswerModel] = []
                do {
                    //2.
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "公司业务性质/范畴/所属行业：", answer:model.business_nature.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "工作职责：", answer:model.wduty)
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "工作亮点：", answer:model.highlights)
                    
                    arr2.append(contentsOf: [tmp1,tmp2,tmp3])
                }
                let dataModel2 = YHWorkExpDataModel(title: "", data: arr2)
                
                var arr3 : [Any] = []
                do {
                    //3.项目介绍
                    if let items = model.projects,items.isEmpty == false {
                        for(index,item) in items.enumerated() {
                            let tmp1 = YHPreviewQuestionAndAnswerModel(question: "项目名称", answer:item.project_name)
                            let title  = item.project_start_time + "-" + item.project_end_time
                            let tmp2 = YHPreviewQuestionAndAnswerModel(question: "项目时间", answer:title)
                            let tmp3 = YHPreviewQuestionAndAnswerModel(question: "项目业绩/亮点", answer:item.project_highlights)
                            let arrT : [YHPreviewQuestionAndAnswerModel] = [tmp1,tmp2,tmp3]
                            
                            
                            let addationIndex = list.count > 1 ? String(index + 1) : ""
                            let dataModelTemp = YHWorkExpDataModel(title: "项目介绍" + addationIndex, data: arrT)
                            arr3.append(dataModelTemp)
                        }
                    }
                }
                let dataModel3 = YHWorkExpDataModel(title: "", data: arr3)
                
                var arr4 : [Any] = []
                do {
                    //4.简历/工作总结：
                    if let items = model.file,items.isEmpty == false {
                        var arrT : [Any] = []
                        for(_,item) in items.enumerated() {
                            arrT.append(item)
                        }
                        let dataModelTemp = YHWorkExpDataModel(title: "简历/工作总结：", data: arrT)
                        arr4.append(dataModelTemp)
                    }
                }
                
                let dataModel4 = YHWorkExpDataModel(title: "", data: arr4)
                
                let addationIndex = list.count > 1 ? String(index + 1) : ""
                let mmmm = YHPreviewInfoSessionModel(cellType: .workExp, cellTitle: "主申请人工作经历" + addationIndex, cellData4: [dataModel1,dataModel2,dataModel3,dataModel4])
                arrDataForWorkExpInfo.append(mmmm)
            }
        }
    }
    
    //组装 学历/专业资格 数据
    func installDataForAcademicInfo() {
        arrDataForAcademicInfo.removeAll()
        guard let model0 = academicInfoPreviewModel else { return}
        do {
            if let arr0 = model0.edu_list {
                for(index,model) in arr0.enumerated() {
                    //主申请人学历
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "学校全称：", answer:model.college)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "授课形式：", answer:model.type)
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "入学年月：", answer:model.admission_time)
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "毕业年月：", answer: model.graduate_time)
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "专业：", answer: model.professional)
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "学位：", answer: model.background)
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "学位类型：", answer: model.degree_type)
                    
                    
                    var title = ""
                    if let item = model.school_address {
                        if item.country.contains("中国") {
                            title = "国内 "
                            if item.area.count > 1 {
                                title = title + item.area[0] + "/" + item.area[1]
                            }
                        } else {
                            title = "国外 " + item.country + "-" + item.foreign
                        }
                    } else {
                        title = "--"
                    }
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "上课地点：", answer:title)
                    
                    let arr = [tmp0,tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,tmp7]
                    
                    let addationIndex = arr0.count > 1 ? String(index + 1) : ""
                    let model2 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "主申请人学历" + addationIndex, cellData0: arr)
                    arrDataForAcademicInfo.append(model2)
                }
            }
        }
        
        do {
            //主申请人专业资格及会员资格
            if let arr = model0.qla_list {
                for(index,model) in arr.enumerated() {
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "资格证书名称：",answer:model.qualification)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "颁授机构全称：", answer:model.college)
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "颁授年份：", answer:String(model.promulgation))
                    
                    var title = ""
                    if let item = model.college_address {
                        if item.country.contains("中国") {
                            title = "国内 "
                            if item.area.count > 1 {
                                title = title + item.area[0] + "/" + item.area[1]
                            }
                        } else {
                            title = "国外 " + item.country + "-" + item.foreign
                        }
                    } else {
                        title = "--"
                    }
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "颁授城市：", answer:title)
                    let arr000 = [tmp0,tmp1,tmp2,tmp3]
                    
                    
                    let addationIndex = arr.count > 1 ? String(index + 1) : ""
                    let model2 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "主申请人专业资格及会员资格" + addationIndex, cellData0: arr000)
                    arrDataForAcademicInfo.append(model2)
                }
            }
        }
        
        do {
            //主申请人
            let title = model0.qla_correct == 1 ? "是" : "否"
            let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、您的所有学历及资格证书的姓名及出生日期，是否与身份证完全一致？（例如：身份证上是【张四】，学位证上是【张三】，则为不同", answer: title)
            
            
            let title2 = model0.edu_correct == 1 ? "是" : "否"
            let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、您配偶的大学毕业证和学位证上的姓名及出生日期，是否与身份证完全一致？", answer: title2)
            let arr = [tmp0,tmp1]
            let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "学历证书姓名及出生日期正确性", cellData0: arr)
            arrDataForAcademicInfo.append(model1)
        }
    }
    
    //组装 主申请人预览 数据
    func installDataForMainApplicationInfo() {
        guard let model = mainApplicationInfoPreviewModel else { return  }
        
        do {
            //国家信息
            let tmp0 = YHPreviewQuestionAndAnswerModel(question: "国家/国籍：", answer: model.nationality)
            let tmp1 = YHPreviewQuestionAndAnswerModel(question: "港澳通行证：", answer: model.is_handled == 0 ? "未办理" : "已办理")
            let arr = [tmp0,tmp1]
            let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "国籍信息", cellData0: arr)
            arrDataForMainApplicationInfo.append(model1)
        }
        
        do {
            //基本信息
            let tmp0 = YHPreviewQuestionAndAnswerModel(question: "主申请人：", answer: model.username)
            let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.used_name.defaultStringIfEmpty())
            let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
            let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
            let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: model.birth_place)
            
            var msg = model.sex//后台 王辉维护这个字段 前端直接展示
            let tmp5 = YHPreviewQuestionAndAnswerModel(question: "性别：", answer: msg)
            
            msg = model.married//后台 王辉维护这个字段 前端直接展示
            let tmp6 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: msg)
            
            let tmp7 = YHPreviewQuestionAndAnswerModel(question: "手机号：", answer: model.mobile)
            let tmp8 = YHPreviewQuestionAndAnswerModel(question: "邮箱：", answer: model.email)
            let tmp9 = YHPreviewQuestionAndAnswerModel(question: "现居住地址：", answer:model.live_address)
            
            
            var arr = [tmp0,tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,tmp7,tmp8,tmp9]
            if model.live_address.contains("中国") == false {
                let tmp10 = YHPreviewQuestionAndAnswerModel(question: "是否在海外居住满1年及以上：", answer: model.is_live_oversea_year == 1 ? "是" : "否")
                arr.append(tmp10)
            } else {
                let tmp10 = YHPreviewQuestionAndAnswerModel(question: "详细地址：", answer: model.live_address_detail.defaultStringIfEmpty())
                arr.append(tmp10)
            }
            
            
            if let card = model.hk_id,card.has.contains("是") {
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: card.number.defaultStringIfEmpty())
                arr.append(tmp5)
                arr.append(tmp6)
            } else {
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                arr.append(tmp5)
            }
            let model2 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "基本信息", cellData0: arr)
            arrDataForMainApplicationInfo.append(model2)
        }
        
        if let model2 = model.certificates {
            //1.跟随 证件信息
            do {
                //中国身份证
                var str = model2.cnIdentityCard.number
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "中国身份证号码：", answer: str.defaultStringIfEmpty())
                
                str = model2.cnIdentityCard.issueAt
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model2.cnIdentityCard.issueDateStartAt
                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model2.cnIdentityCard.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp3 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model0 = YHPersonInfoCellModel1(cellTitle: "中国身份证", cellData: [tmp0,tmp1,tmp2,tmp3])
                
                
                var arr = [model0]
                //港澳通行证
                if model.is_handled == 1 {
                    str = model2.hkMacaoPass.number
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "旅行社证件号码：", answer: str.defaultStringIfEmpty())
                    
                    str = model2.hkMacaoPass.issueAt
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                    
                    str = model2.hkMacaoPass.issueDateStartAt
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                    
                    str = model2.hkMacaoPass.issueDateEndAt
                    if str.isEmpty {
                        str = ""
                    } else {
                        if str == "8888-01-01" {
                            str = "长期"
                        }
                    }
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                    let model1 = YHPersonInfoCellModel1(cellTitle: "港澳通行证", cellData: [tmp4,tmp5,tmp6,tmp7])
                    arr.append(model1)
                }
                
                
                if model.nationality != "中国-China" {
                    //护照及其他旅行证件
                    var str = model2.passport.type
                    let tmp8 = YHPreviewQuestionAndAnswerModel(question: "证件类别：", answer: str)
                    
                    str = model2.passport.number
                    let tmp9 = YHPreviewQuestionAndAnswerModel(question: "证件号码：", answer: str.defaultStringIfEmpty())
                    
                    str = model2.passport.issueAt
                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                    
                    str = model2.passport.issueDateStartAt
                    let tmp11 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                    
                    str = model2.passport.issueDateEndAt
                    if str.isEmpty {
                        str = ""
                    } else {
                        if str == "8888-01-01" {
                            str = "长期"
                        }
                    }
                    let tmp12 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                    
                    let model2 = YHPersonInfoCellModel1(cellTitle: "护照及其他旅行证件", cellData: [tmp8,tmp9,tmp10,tmp11,tmp12])
                    arr.append(model2)
                }
                let model3 = YHPreviewInfoSessionModel(cellType: .idCardInfoType, cellTitle: "证件信息", cellData1: arr)
                arrDataForMainApplicationInfo.append(model3)
            }
            
            //2.跟随 证件照
            do {
                //证件照片
                let front = model2.cnIdentityCard.imgFront
                let back = model2.cnIdentityCard.imgBack
                let model1 = YHPersonInfoCellModel2(cellTitle: "中国身份证",frontUrl: front, backUrl: back, idType: 1)
                var arr = [model1]
                
                if model.is_handled == 1 {
                    let front = model2.hkMacaoPass.imgFront
                    let back = model2.hkMacaoPass.imgBack
                    let model2 = YHPersonInfoCellModel2(cellTitle: "港澳通行证",frontUrl: front, backUrl: back, idType: 2)
                    arr.append(model2)
                }
                
                let model4 = YHPreviewInfoSessionModel(cellType: .idPictureType, cellTitle: "证件照片", cellData2: arr)
                arrDataForMainApplicationInfo.append(model4)
            }
        }
    }
    
    //组装 基本资料预览 数据
    func installDataForBasicInfo() {
        do {
            //主申请人
            if let model = basiceInfoPreviewModel?.applicant {
                let answer0 = model.has_conviction?.has == "Y" ? "是" : "否"
                let remark0 = answer0 == "是" ? (model.has_conviction?.info ?? "") : nil
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、是否曾在香港或其他地方因任何罪行或违法行为被被定罪：", answer: answer0,remark: remark0)
                
                
                let answer1 = model.has_departure?.has == "Y" ? "是" : "否"
                let remark1 = answer1 == "是" ? (model.has_departure?.info ?? "") : nil
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、是否曾在香港或其他地方被拒入境/递解/遣送或要求离境？", answer: answer1,remark: remark1)
                
                
                let answer2 = model.has_deny?.has == "Y" ? "是" : "否"
                let remark2 = answer2 == "是" ? (model.has_deny?.info ?? "") : nil
                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "3、是否曾被拒绝签发香港或其他地方的签证/进入许可？", answer: answer2,remark: remark2)
                
                
                let answer3 = model.has_breaking_law?.has == "Y" ? "是" : "否"
                let remark3 = answer3 == "是" ? (model.has_breaking_law?.info ?? "") : nil
                let tmp3 = YHPreviewQuestionAndAnswerModel(question: "4、是否曾触犯香港或任何地方的入境法例？", answer: answer3,remark:remark3)
                
                let answer4 = model.has_other_id?.has == "Y" ? "是" : "否"
                let remark4 = answer4 == "是" ? (model.has_other_id?.info ?? "") : nil
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "5、是否曾经使用另一个姓名或身份申请香港入境签证/进入许可或进入香港？", answer: answer4,remark: remark4)
                
                let arr = [tmp0,tmp1,tmp2,tmp3,tmp4]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "主申请人", cellData0: arr)
                arrDataForBasicInfo.append(model1)
            }
        }
        
        
        do {
            //子女 - xxx
            if let arrChild = basiceInfoPreviewModel?.child {
                for (_,model) in arrChild.enumerated() {
                    let answer0 = model.child_departure?.has == "Y" ? "是" : "否"
                    let remark0 = answer0 == "是" ? (model.child_departure?.info ?? "") : nil
                    
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、是否曾被拒绝入境/递解/遣送或要求离开香港？", answer: answer0,remark:remark0)
                    
                    
                    let answer1 = model.child_deny?.has == "Y" ? "是" : "否"
                    let remark1 = answer1 == "是" ? (model.child_deny?.info ?? "") : nil
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、是否曾被拒绝签发签证/进入许可以入境香港？", answer: answer1,remark: remark1)
                    let arr = [tmp0,tmp1]
                    
                    
                    let title = "子女" + "-" + model.subset_name
                    let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: title, cellData0: arr)
                    arrDataForBasicInfo.append(model1)
                }
            }
        }
        
        
        
        do {
            //配偶
            if let model = basiceInfoPreviewModel?.spouse {
                let answer0 = model.child_departure?.has == "Y" ? "是" : "否"
                let remark0 = answer0 == "是" ? (model.child_departure?.info ?? "") : nil
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、是否曾被拒绝入境/递解/遣送或要求离开香港？", answer: answer0,remark:remark0)
                
                let answer1 = model.child_deny?.has == "Y" ? "是" : "否"
                let remark1 = answer1 == "是" ? (model.child_deny?.info ?? "") : nil
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、是否曾被拒绝签发签证/进入许可以入境香港？", answer: answer1,remark: remark1)
                let arr = [tmp0,tmp1]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "配偶", cellData0: arr)
                arrDataForBasicInfo.append(model1)
            }
        }
        
        do {
            //家庭背景
            if let model = basiceInfoPreviewModel?.background {
                let answer0 = model.background_member?.has == "Y" ? "满足" : "不满足"
                
                var msg = ""
                if answer0.contains("满足") {
                    if let str = model.background_member?.info,str.isEmpty == false {
                        if model.subset.isEmpty == false {
                            for item in model.subset {
                                let ttt = String(item.id)
                                if ttt.contains(str) {
                                    msg = item.subset_name
                                    break
                                }
                            }
                        }
                    }
                    msg = msg.defaultStringIfEmpty()
                }
                let remark0 = answer0 == "满足" ? msg : nil
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、至少一名直系家庭成员（已婚配偶、父母、兄弟姐妹、子女）是现居于香港的香港永久性居民", answer:answer0,remark: remark0)
                let arr = [tmp0]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "家庭背景", cellData0: arr)
                arrDataForBasicInfo.append(model1)
            }
        }
    }
    
    //组装 其他信息预览 数据
    func installDataForOtherInfo() {
        guard let model = otherInfoPreviewModel else {
            return
        }
        
        handleDataForOtherInfo()
        
        do {
            
            if let arr1 = model.list,arr1.isEmpty == false {
                var arr : [YHPersonInfoCellModel1] = []
                for (index,item) in arr1.enumerated() {
                    
                    //居住信息
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "开始时间：", answer: item.start_time)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "结束时间：", answer: item.end_time)
                    
                    
                    let addationIndex = arr1.count > 1 ? String(index + 1) : ""
                    let title = "国家" + addationIndex + ":" + item.country
                    let model0 = YHPersonInfoCellModel1(cellTitle: title, cellData: [tmp0,tmp1])
                    
                    arr.append(model0)
                }
                
                let model3 = YHPreviewInfoSessionModel(cellType: .idCardInfoType, cellTitle: "居住信息", cellData1: arr)
                arrDataForOtherInfo.append(model3)
            }
        }
        
        
        do {
            //语言能力
            if let model = otherInfoPreviewModel?.language {
                var title = ""
                if model.level == 4 {
                    title = model.name.defaultStringIfEmpty() + "\n" + model.remark.defaultStringIfEmpty()
                }
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: model.levelDes, answer: model.localRemark,remark: title)
                let arr = [tmp0]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "语言能力", cellData0: arr)
                arrDataForOtherInfo.append(model1)
                
            }
        }
        
        do {
            //专业技能行业
            if let model = otherInfoPreviewModel?.profession {
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、最能代表你的专业技能的行业是？（单选）", answer: model.optionDes,remark: model.remark)
                let arr = [tmp0]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "专业技能行业", cellData0: arr)
                arrDataForOtherInfo.append(model1)
            }
        }
        
        do {
            //其他问题
            if let model = otherInfoPreviewModel?.question {
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、您是否有行业内的专业资格证书？", answer: model.professional_qualification == 1 ? "是" : "否")
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、您是否在期刊或杂志上发表论文、文章、书籍等（与工作、资质有关的）？", answer: model.paper == 1 ? "是" : "否")
                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "3、您是否有大学奖学金证明、专利证书、获奖证书（工作单位颁发的可以）？", answer: model.scholarship == 1 ? "是" : "否")
                let tmp3 = YHPreviewQuestionAndAnswerModel(question: "4、您是否被媒体采访过，专访您的文章被发表在杂志上或网络上？", answer: model.media_interview == 1 ? "是" : "否")
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "5、专业奖项：", answer: model.professional_awards)
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "6、学业奖项：", answer: model.academic_awards)
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "7、其他资料：", answer: model.other_information)
                let arr = [tmp0,tmp1,tmp2,tmp3,tmp4,tmp5,tmp6]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "辅助资料", cellData0: arr)
                arrDataForOtherInfo.append(model1)
            }
        }
    }
}


private extension YHPreviewViewModel {
    //特殊处理 其他信息预览 需要的数据
    func handleDataForOtherInfo() {
        if let language = otherInfoPreviewModel?.language {
            if language.level > 0 {
                let target = String(language.level)
                for(_,item) in YHConstantArrayData.arrLanguage.enumerated() {
                    
                    if target == item["id"] {
                        language.levelDes = item["title"] ?? "--"
                        language.localRemark = item["dec"] ?? "--"
                        break
                    }
                }
            }
        }
        
        
        
        if let profession = otherInfoPreviewModel?.profession {
            if profession.option > 0 {
                let target = String(profession.option)
                for(_,item) in YHConstantArrayData.arrSkill.enumerated() {
                    
                    if target == item["value"] {
                        profession.optionDes = item["title"] ?? "--"
                        break
                    }
                }
            }
        }
    }
}


private extension YHPreviewViewModel {
    func installDataForFamilyInfo() {
        //父母
        installDataForParents()
        
        //配偶
        installDataForSpouse()
        
        //子女
        installDataForChildren()
        
        //兄弟姐妹
        installDataForBrother()
    }
    
    //父母 数据
    func installDataForParents() {
        do {
            if let model = familyInfoPreviewModel?.father {
                if model.deceased == 0 {
                    //父亲信息-健在
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "父亲姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "是否已故：", answer: "否")
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        //国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        //国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    let tmp11 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married)
                    
                    
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "职业：", answer: model.occupation)
                    var arr = [tmp0,tmp1,tmp2,tmp3,tmp11,tmp4]
                    if model.occupation.contains("在职") {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业名称：", answer: model.occupationName)
                        arr.append(tmp5)
                    }
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "现居住国家/地区：", answer: model.liveCountry)
                    arr.append(tmp6)
                    
                    
//                    var arr = [tmp0,tmp1,tmp2,tmp3,tmp11,tmp4,tmp5,tmp6]
                    if let card = model.hkIdentityCard,card.isEmpty == false {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                        let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                        arr.append(tmp5)
                        arr.append(tmp6)
                    } else {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                        arr.append(tmp5)
                    }
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "父亲信息", cellData0: arr)
                    arrDataForParents.append(model1)
                    
                } else {
                    //父亲信息-已故
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "父亲姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "是否已故：", answer: "是")
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        //国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        //国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    let arr = [tmp0,tmp1,tmp2,tmp3]
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "父亲信息", cellData0: arr)
                    arrDataForParents.append(model1)
                }
            } else {
                printLog("error:父亲数据不存在")
            }
        }
        
        
        do {
            if let model = familyInfoPreviewModel?.mother {
                if model.deceased == 0 {
                    //母亲信息-健在
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "母亲姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "是否已故：", answer: "否")
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        //国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        //国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    
                    let tmp11 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married)
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "职业：", answer: model.occupation)
                    
                    var arr = [tmp0,tmp1,tmp2,tmp3,tmp11,tmp4]
                    if model.occupation.contains("在职") {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业名称：", answer: model.occupationName)
                        arr.append(tmp5)
                    }
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "现居住国家/地区：", answer: model.liveCountry)
                    arr.append(tmp6)
                    
//                    var arr = [tmp0,tmp1,tmp2,tmp3,tmp11,tmp4,tmp5,tmp6]
                    if let card = model.hkIdentityCard,card.isEmpty == false {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                        let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                        arr.append(tmp5)
                        arr.append(tmp6)
                    } else {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                        arr.append(tmp5)
                    }
                    
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "母亲信息-健在", cellData0: arr)
                    arrDataForParents.append(model1)
                } else {
                    //母亲信息-已故
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "母亲信息：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "是否已故：", answer: "是")
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        //国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        //国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    let arr = [tmp0,tmp1,tmp2,tmp3]
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "母亲信息", cellData0: arr)
                    arrDataForParents.append(model1)
                }
            } else {
                printLog("error:母亲数据不存在")
            }
        }
        arrDataForFamilyInfo = arrDataForParents
    }
    
    private func installDataForSpouseOp(model : YHFamilyMember) {
        
        var arrTemp : [YHPreviewInfoSessionModel] = []
        do {
            if model.follow == 1 {
                
                do {
                    //随行信息 - 是
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "是否随行至香港：", answer: "是")
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "国家/国籍：", answer: model.nationality)
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "港澳通行证：", answer: model.isHandled == 1 ? "已办理" : "未办理")
                    let arr = [tmp0,tmp1,tmp2]
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "随行信息", cellData0: arr)
                    arrTemp.append(model1)
                }
                
                
                do {
                    //配偶信息
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "配偶姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.usedName.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        //国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        //国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业：", answer: model.occupation)
                    
                    
                    var arr = [tmp0,tmp1,tmp2,tmp3,tmp4,tmp5]
                    if model.occupation.contains("在职") {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业名称：", answer: model.occupationName)
                        arr.append(tmp5)
                    }
                    
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "是否拥有学位：", answer: model.hasDegree == "1" ? "有学位" : "无学位")
                    arr.append(tmp7)
                    
                    if model.hasDegree == "1" {
                        for(index,item) in model.hasDegreeJson.enumerated() {
                            
                            let addationIndex = model.hasDegreeJson.count > 1 ? String(index + 1) : ""
                            let title = "学位证" + addationIndex + "："
                            let tmp8 = YHPreviewQuestionAndAnswerModel(question: title, answer: YHConstantArrayData.getShowNameBy(indexStr: item.degree, type: .degree))
                            arr.append(tmp8)
                            let tmp9 = YHPreviewQuestionAndAnswerModel(question: "学位证颁发地区：", answer: YHConstantArrayData.getShowNameBy(indexStr: item.address, type: .degreeAddress))
                            arr.append(tmp9)
                        }
                    }
                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "是否和主申请人同住：", answer: model.nows == 1 ? "是" : "否")
                    arr.append(tmp10)
                    
                    var liveAbord = false //海外
                    var address = ""
                    if model.nows == 0 {
                        var title = ""
                        if model.address.country.contains("中国") {
                            //国内
                            title = "国内 "
                            if model.address.area.count > 1 {
                                title = title + model.address.area[0] + "/" + model.address.area[1]
                            } else {
                                title = "国内 --"
                            }
                            address = model.address.details
                        } else {
                            //国外
                            title = model.address.country
                            liveAbord = true
                            
                            address = model.address.foreign
                        }
                        let tmp11 = YHPreviewQuestionAndAnswerModel(question: "现居住地址：", answer: title)
                        arr.append(tmp11)
                    }
                    
                    if liveAbord == true {
                        let title = model.isLiveOverseaYear == 1 ? "是" : "否"
                        let tmp12 = YHPreviewQuestionAndAnswerModel(question: "是否在海外居住满1年及以上：", answer: title)
                        arr.append(tmp12)
                    }
                    let tmp133 = YHPreviewQuestionAndAnswerModel(question: "详细地址：", answer: address.defaultStringIfEmpty())
                    arr.append(tmp133)
                    
                    let tmp13 = YHPreviewQuestionAndAnswerModel(question: "目前是否在港：", answer: model.hkIdentity.isEmpty == false ? "是" : "否")
                    arr.append(tmp13)
                    
                    if model.hkIdentity.isEmpty == false {
                        let tmp14 = YHPreviewQuestionAndAnswerModel(question: "获准逗留至：", answer: model.childInHk.info)
                        
                        let tmp15 = YHPreviewQuestionAndAnswerModel(question: "在港身份：", answer: model.hkIdentity == "其他" ? (model.hkIdentityOther.defaultStringIfEmpty(detaultValue: "其他")) : model.hkIdentity)
                        arr.append(contentsOf: [tmp14,tmp15])
                    }
                    
                    if let tmp = model.hkIdentityCard,tmp.isEmpty == false {
                        let tmp16 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                        arr.append(tmp16)
                        
                        let tmp17 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: tmp)
                        arr.append(tmp17)
                    } else {
                        let tmp16 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                        arr.append(tmp16)
                    }
                    let model2 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "配偶信息", cellData0: arr)
                    arrTemp.append(model2)
                }
            } else {
                do {
                    //随行信息 - 否
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "是否随行至香港：", answer: "否")
                    let arr = [tmp0]
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "随行信息", cellData0: arr)
                    arrTemp.append(model1)
                }
                
                do {
                    //配偶信息-否
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "配偶姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.usedName.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        //国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        //国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    
                    
                    var arr = [tmp0,tmp1,tmp2,tmp3,tmp4]
                    if let card = model.hkIdentityCard,card.isEmpty == false {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                        let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                        arr.append(tmp5)
                        arr.append(tmp6)
                    } else {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                        arr.append(tmp5)
                    }
                    
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "配偶信息", cellData0: arr)
                    arrTemp.append(model1)
                }
                
            }
        }
        
        if model.isFollow() {
            //1.跟随 证件信息
            do {
                //中国身份证
                var str = model.certificates.cnIdentityCard.number
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "中国身份证号码：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueAt
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                str = model.certificates.cnIdentityCard.issueDateStartAt
                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp3 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model0 = YHPersonInfoCellModel1(cellTitle: "中国身份证", cellData: [tmp0,tmp1,tmp2,tmp3])
                
                
                var arr = [model0]
                //港澳通行证
                if model.isHandled == 1 {
                    str = model.certificates.hkMacaoPass.number
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "旅行社证件号码：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.hkMacaoPass.issueAt
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.hkMacaoPass.issueDateStartAt
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.hkMacaoPass.issueDateEndAt
                    if str.isEmpty {
                        str = ""
                    } else {
                        if str == "8888-01-01" {
                            str = "长期"
                        }
                    }
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                    let model1 = YHPersonInfoCellModel1(cellTitle: "港澳通行证", cellData: [tmp4,tmp5,tmp6,tmp7])
                    arr.append(model1)
                }
                
                
                if model.nationality != "中国-China" {
                    //护照及其他旅行证件
                    var str = YHConstantArrayData.getShowNameBy(indexStr: String(model.certificates.passport.passPortType), type: .idType)
                    let tmp8 = YHPreviewQuestionAndAnswerModel(question: "证件类别：", answer: str)
                    
                    str = model.certificates.passport.number
                    let tmp9 = YHPreviewQuestionAndAnswerModel(question: "证件号码：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.passport.issueAt
                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.passport.issueDateStartAt
                    let tmp11 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.passport.issueDateEndAt
                    if str.isEmpty {
                        str = ""
                    } else {
                        if str == "8888-01-01" {
                            str = "长期"
                        }
                    }
                    let tmp12 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                    let model2 = YHPersonInfoCellModel1(cellTitle: "护照及其他旅行证件", cellData: [tmp8,tmp9,tmp10,tmp11,tmp12])
                    arr.append(model2)
                }
                let model3 = YHPreviewInfoSessionModel(cellType: .idCardInfoType, cellTitle: "证件信息", cellData1: arr)
                arrTemp.append(model3)
            }
            
            //2.跟随 证件照
            do {
                //证件照片
                let front = model.certificates.cnIdentityCard.imgFront
                let back = model.certificates.cnIdentityCard.imgBack
                let model1 = YHPersonInfoCellModel2(cellTitle: "中国身份证",frontUrl: front, backUrl: back, idType: 1)
                var arr = [model1]
                
                if model.isHandled == 1 {
                    let front = model.certificates.hkMacaoPass.imgFront
                    let back = model.certificates.hkMacaoPass.imgBack
                    let model2 = YHPersonInfoCellModel2(cellTitle: "港澳通行证",frontUrl: front, backUrl: back, idType: 2)
                    arr.append(model2)
                }
                
                let model4 = YHPreviewInfoSessionModel(cellType: .idPictureType, cellTitle: "证件照片", cellData2: arr)
                arrTemp.append(model4)
            }
        }
        
        arrDataForSpouse = arrTemp
    }
    
    //配偶 数据
    func installDataForSpouse() {
        guard let model = familyInfoPreviewModel?.spouse else {
            printLog("error:配偶数据不存在")
            return
        }
        arrDataForSpouse.removeAll()
        installDataForSpouseOp(model: model)
    }
    
    private func installDataForChildOp(model : YHFamilyMember,childIndex : Int, totalChild : Int = 0) {
        var arrTemp : [YHPreviewInfoSessionModel] = []
        do {
            if model.follow == 1 {
                do {
                    //随行信息 - 是
                    let tmp00 = YHPreviewQuestionAndAnswerModel(question: "主申请人或现配偶是否拥有孩子护养权：", answer:model.custody == 1 ? "是" : "否")
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "该子女是否随行至香港：", answer: "是")
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "国家/国籍：", answer: model.nationality)
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "港澳通行证：", answer: model.isHandled == 1 ? "已办理" : "未办理")
                    let arr = [tmp00,tmp0,tmp1,tmp2]
                    
                    var title = ""
                    if totalChild > 1 {
                        title = String(childIndex + 1)
                    }
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "随行信息" + title, cellData0: arr)
                    arrTemp.append(model1)
                }
                do {
                    //子女信息
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "子女姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.usedName.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
                    
                    let sexStr = YHConstantArrayData.getShowNameBy(indexStr: String(model.sex), type: .sex)
                    let tmp22 = YHPreviewQuestionAndAnswerModel(question: "性别：", answer: sexStr)
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        //国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        //国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married)
                    
                    let tmp55 = YHPreviewQuestionAndAnswerModel(question: "职业：", answer: model.occupation)
                    
                    var arr = [tmp0,tmp1,tmp2,tmp22,tmp3,tmp4,tmp5,tmp55]
                    if model.occupation.contains("在职") {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业名称：", answer: model.occupationName)
                        arr.append(tmp5)
                    }
                    
//                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "是否拥有学位：", answer: model.hasDegree == "1" ? "有学位" : "无学位")
//                    arr.append(tmp7)
//                    
//                    if model.hasDegree == "1" {
//                        for(index,item) in model.hasDegreeJson.enumerated() {
//                            
//                            let addationIndex = model.hasDegreeJson.count > 1 ? String(index + 1) : ""
//                            let title = "学位证" + addationIndex + "："
//                            let tmp8 = YHPreviewQuestionAndAnswerModel(question: title, answer: item.degree)
//                            arr.append(tmp8)
//                            let tmp9 = YHPreviewQuestionAndAnswerModel(question: "学位证颁发地区：", answer: item.address)
//                            arr.append(tmp9)
//                        }
//                    }
                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "是否和主申请人同住：", answer: model.nows == 1 ? "是" : "否")
                    arr.append(tmp10)
                    
                    var liveAbord = false //海外
                    var address = ""
                    if model.nows == 0 {
                        var title = ""
                        if model.address.country.contains("中国") {
                            //国内
                            title = "国内 "
                            if model.address.area.count > 1 {
                                title = title + model.address.area[0] + "/" + model.address.area[1]
                            } else {
                                title = "国内 --"
                            }
                            address = model.address.details
                        } else {
                            //国外
                            title = model.address.country
                            liveAbord = true
                            
                            address = model.address.foreign
                        }
                        let tmp11 = YHPreviewQuestionAndAnswerModel(question: "现居住地址：", answer: title)
                        arr.append(tmp11)
                    }
                    
                    if liveAbord == true {
                        let title = model.isLiveOverseaYear == 1 ? "是" : "否"
                        let tmp12 = YHPreviewQuestionAndAnswerModel(question: "是否在海外居住满1年及以上：", answer: title)
                        arr.append(tmp12)
                    }
                    
                    if model.nows == 0 {
                        let tmp133 = YHPreviewQuestionAndAnswerModel(question: "详细地址：", answer: address.defaultStringIfEmpty())
                        arr.append(tmp133)
                    }
                    
                    let tmp13 = YHPreviewQuestionAndAnswerModel(question: "目前是否在港：", answer: model.hkIdentity.isEmpty == false ? "是" : "否")
                    arr.append(tmp13)
                    
                    if model.hkIdentity.isEmpty == false {
                        let tmp14 = YHPreviewQuestionAndAnswerModel(question: "获准逗留至：", answer: model.childInHk.info)
                        
                        let tmp15 = YHPreviewQuestionAndAnswerModel(question: "在港身份：", answer: model.hkIdentity == "其他" ? (model.hkIdentityOther.defaultStringIfEmpty(detaultValue: "其他")) : model.hkIdentity)
                        arr.append(contentsOf: [tmp14,tmp15])
                    }
                    
                    
                    
                    if let tmp = model.hkIdentityCard,tmp.isEmpty == false {
                        let tmp16 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                        arr.append(tmp16)
                        
                        let tmp17 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: tmp)
                        arr.append(tmp17)
                    } else {
                        let tmp16 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                        arr.append(tmp16)
                    }
                    
                    
                    var title = ""
                    if totalChild > 1 {
                        title = String(childIndex + 1)
                    }
                    let model2 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "子女信息" + title, cellData0: arr)
                    arrTemp.append(model2)
                }
                
                
                
            } else {
                do {
                    //随行信息 - 否
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "是否随行至香港：", answer: "否")
                    let arr = [tmp0]
                    
                    
                    
                    var title = ""
                    if totalChild > 1 {
                        title = String(childIndex + 1)
                    }
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "随行信息" + title, cellData0: arr)
                    arrTemp.append(model1)
                }
                
                do {
                    //配偶信息-否
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "配偶姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.usedName.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
                    let sexStr = YHConstantArrayData.getShowNameBy(indexStr: String(model.sex), type: .sex)
                    let tmp22 = YHPreviewQuestionAndAnswerModel(question: "性别：", answer: sexStr)
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        //国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        //国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    let tmp44 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married.defaultStringIfEmpty())
                    let tmp444 = YHPreviewQuestionAndAnswerModel(question: "职业：", answer: model.occupation.defaultStringIfEmpty())
                    
                    var arr = [tmp0,tmp1,tmp2,tmp22,tmp3,tmp4,tmp44,tmp444]
                    if model.occupation.contains("在职") {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业名称：", answer: model.occupationName)
                        arr.append(tmp5)
                    }
                    
                    if let card = model.hkIdentityCard,card.isEmpty == false {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                        let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                        arr.append(tmp5)
                        arr.append(tmp6)
                    } else {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                        arr.append(tmp5)
                    }
                    
                    
                    var title = ""
                    if totalChild > 1 {
                        title = String(childIndex + 1)
                    }
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "子女信息" + title, cellData0: arr)
                    arrTemp.append(model1)
                }
            }
        }
        
        if model.isFollow() {
            //1.跟随 证件信息
            do {
                //中国身份证
                var str = model.certificates.cnIdentityCard.number
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "中国身份证号码：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueAt
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueDateStartAt
                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp3 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model0 = YHPersonInfoCellModel1(cellTitle: "中国身份证", cellData: [tmp0,tmp1,tmp2,tmp3])
                
                
                var arr = [model0]
                //港澳通行证
                if model.isHandled == 1 {
                    str = model.certificates.hkMacaoPass.number
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "旅行社证件号码：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.hkMacaoPass.issueAt
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str)
                    
                    str = model.certificates.hkMacaoPass.issueDateStartAt
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.hkMacaoPass.issueDateEndAt
                    if str.isEmpty {
                        str = ""
                    } else {
                        if str == "8888-01-01" {
                            str = "长期"
                        }
                    }
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                    let model1 = YHPersonInfoCellModel1(cellTitle: "港澳通行证", cellData: [tmp4,tmp5,tmp6,tmp7])
                    arr.append(model1)
                }
                
                
                if model.nationality != "中国-China" {
                    //护照及其他旅行证件
                    var str = YHConstantArrayData.getShowNameBy(indexStr: String(model.certificates.passport.passPortType), type: .idType)
                    let tmp8 = YHPreviewQuestionAndAnswerModel(question: "证件类别：", answer: str)
                    
                    str = model.certificates.passport.number
                    let tmp9 = YHPreviewQuestionAndAnswerModel(question: "证件号码：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.passport.issueAt
                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                    
                    str = model.certificates.passport.issueDateStartAt
                    let tmp11 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str)
                    
                    str = model.certificates.passport.issueDateEndAt
                    if str.isEmpty {
                        str = ""
                    } else {
                        if str == "8888-01-01" {
                            str = "长期"
                        }
                    }
                    let tmp12 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                    
                    let model2 = YHPersonInfoCellModel1(cellTitle: "护照及其他旅行证件", cellData: [tmp8,tmp9,tmp10,tmp11,tmp12])
                    arr.append(model2)
                }
                
                
                var title = ""
                if totalChild > 1 {
                    title = String(childIndex + 1)
                }
                let model3 = YHPreviewInfoSessionModel(cellType: .idCardInfoType, cellTitle: "证件信息" + title, cellData1: arr)
                arrTemp.append(model3)
            }
            
            //2.跟随 证件照
            do {
                //证件照片
                let front = model.certificates.cnIdentityCard.imgFront
                let back = model.certificates.cnIdentityCard.imgBack
                let model1 = YHPersonInfoCellModel2(cellTitle: "中国身份证",frontUrl: front, backUrl: back, idType: 1)
                var arr = [model1]
                
                if model.isHandled == 1 {
                    let front = model.certificates.hkMacaoPass.imgFront
                    let back = model.certificates.hkMacaoPass.imgBack
                    let model2 = YHPersonInfoCellModel2(cellTitle: "港澳通行证",frontUrl: front, backUrl: back, idType: 2)
                    arr.append(model2)
                }
                
                
                var title = ""
                if totalChild > 1 {
                    title = String(childIndex + 1)
                }
                let model4 = YHPreviewInfoSessionModel(cellType: .idPictureType, cellTitle: "证件照片" + title, cellData2: arr)
                arrTemp.append(model4)
            }
        }
        
        arrDataForChildren.append(contentsOf: arrTemp)
    }
    
    //子女 数据
    func installDataForChildren() {
        guard let model1 = familyInfoPreviewModel?.child else {
            return
        }
        arrDataForChildren.removeAll()
        for(index,model) in model1.enumerated() {
            installDataForChildOp(model: model, childIndex:index,totalChild: model1.count)
        }
    }
    
    //兄弟姐妹 数据
    func installDataForBrother() {
        
        guard let model1 = familyInfoPreviewModel?.brother else {
            return
        }
        
        do {
            //兄弟姐妹信息
            
            for model in model1 {
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "姓名：", answer: model.subsetName)
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married)
                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                var city = ""
                if model.birthPlaceAboard == 0 {
                    //国内
                    if model.birthPlace.area.count > 1 {
                        city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                    } else {
                        city = "国内 --"
                    }
                } else {
                    //国外
                    city = "国外 " + model.birthPlace.foreign
                }
                let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "职业：", answer: model.occupation)
                
                var arr = [tmp0,tmp1,tmp2,tmp3,tmp4]
                if model.occupation.contains("在职") {
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业名称：", answer: model.occupationName)
                    arr.append(tmp5)
                }
                
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "现居住国家/地区：", answer: model.liveCountry)
                arr.append(tmp6)
                
                if let str = model.hkIdentityCard,str.isEmpty == false {
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                    let tmp8 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                    arr.append(tmp7)
                    arr.append(tmp8)
                    
                } else {
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                    arr.append(tmp7)
                }
                let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "兄弟姐妹信息", cellData0: arr)
                arrDataForBrother.append(model1)
            }
        }
    }
}
