//
//  YHWorkFileItemView.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHWorkFileClickType {
    case delete
    case click
}

class YHWorkFileItemView: UIView {
    typealias ItemBlock = (_ model: YHWorkExperienceFileModel, _ type: YHWorkFileClickType) -> ()
    var block: ItemBlock?
    var whiteView: UIButton!
    var iconImgV: UIImageView!
    var nameLabel: UILabel!
    var timeLabel: UILabel!
    var editBtn: UIButton!
    var dataSource: YHWorkExperienceFileModel? {
        didSet {
            updateAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        whiteView = UIButton()
        whiteView.addTarget(self, action: #selector(itemClick), for: .touchUpInside)
        addSubview(whiteView)
        
        iconImgV = UIImageView(image:UIImage(named:"my_cer_type_jpg"))
        whiteView.addSubview(iconImgV)
        
        nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.textAlignment = .left
        nameLabel.numberOfLines = 0
        nameLabel.font = UIFont.PFSC_M(ofSize:14)
        whiteView.addSubview(nameLabel)
        
        timeLabel = UILabel()
        timeLabel.textColor = UIColor.labelTextColor2
        timeLabel.textAlignment = .left
        timeLabel.font = UIFont.PFSC_R(ofSize:11)
        whiteView.addSubview(timeLabel)
        
        editBtn = UIButton()
        editBtn.setImage(UIImage(named:"my_cer_btn_edit"), for:.normal)
        editBtn.YH_clickEdgeInsets = UIEdgeInsets(top: 30, left: 30, bottom: 30, right: 30)
        editBtn.addTarget(self, action: #selector(deleteClick), for: .touchUpInside)
        whiteView.addSubview(editBtn)
        
        whiteView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.centerY.equalToSuperview()
            make.height.equalTo(55)
        }

        iconImgV.snp.makeConstraints { make in
            make.width.height.equalTo(31)
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(6)
        }
        
        nameLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgV.snp.right).offset(18)
            make.top.equalToSuperview().offset(7)
            make.right.equalTo(editBtn.snp.left)
        }
        
        timeLabel.snp.makeConstraints { make in
            make.left.right.equalTo(nameLabel)
            make.top.equalTo(nameLabel.snp.bottom).offset(2)
            make.bottom.equalToSuperview().offset(-7)
            make.height.equalTo(20)
        }
        
        editBtn.snp.makeConstraints { make in
            make.width.height.equalTo(16)
            make.centerY.equalToSuperview()
            make.right.equalToSuperview()
        }
        
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        nameLabel.text = dataSource.fileName
        timeLabel.text = "上传于\(dataSource.uploadedAt)"
        let suffix = dataSource.fileUrl.pathExtension.lowercased()
        var iconImgName = ""
        
        if suffix == "jpeg" {
            iconImgName = "my_cer_type_jpg"
            
        } else if suffix == "jpg" {
            iconImgName = "my_cer_type_jpg"
            
        } else if suffix == "png" {
            iconImgName = "my_cer_type_png"
            
        } else if suffix == "pdf" {
            iconImgName = "my_cer_type_pdf"
            
        } else if suffix == "doc" || suffix == "docx" {
            iconImgName = "my_cer_type_word"
        
        } else if suffix == "ppt" || suffix == "pptx" {
            iconImgName = "my_cer_type_ppt"
        } else if suffix == "bmp" {
            iconImgName = "my_cer_type_bmp"
        } else if suffix == "tiff" {
            iconImgName = "my_cer_type_tiff"
        }
        
        iconImgV.image = UIImage(named: iconImgName)
    }
    
    @objc func itemClick() {
        if let block = block, let dataSource = dataSource {
            block(dataSource, .click)
        }
    }
    
    @objc func deleteClick() {
        if let block = block, let dataSource = dataSource {
            block(dataSource, .delete)
        }
    }
}
