//
//  YHContractCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHContractCell: UITableViewCell {
    static let cellReuseIdentifier = "YHContractCell"
    
    var dataModel : YHContactItemModel? {
        didSet {
            updateUI()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var contractNameLable = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.font = UIFont.PFSC_M(ofSize: 17)
        lable.text = ""
        return lable
    }()
    
    lazy var contractIdLable = {
        let lable = UILabel()
        lable.textColor = UIColor.labelTextColor2
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.text = ""
        
        return lable
    }()
    
    
    
    
    
    
}

extension YHContractCell {
    func updateUI() {
        contractNameLable.text = dataModel?.productName ?? "-" + " - " + (dataModel?.username ?? "-")
        let str = "合同编号：" + (dataModel?.orderSn ?? "-")
        contractIdLable.text = str
    }
    
    func setupUI() {
        let holdView = UIView()
        holdView.backgroundColor = .white
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
        }
        
        
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "service_center_right_next_icon")
        nextImgV.contentMode = .scaleAspectFill
        holdView.addSubview(nextImgV)
        nextImgV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-kMargin)
            make.width.height.equalTo(kMargin)
        }
        
        
        holdView.addSubview(contractNameLable)
        contractNameLable.snp.makeConstraints { make in
            make.top.equalTo(kMargin)
            make.left.equalTo(21)
            make.right.equalTo(nextImgV.snp.left).offset(-10)
            make.height.equalTo(24)
        }
        
        
        holdView.addSubview(contractIdLable)
        contractIdLable.snp.makeConstraints { make in
            make.top.equalTo(contractNameLable.snp.bottom).offset(4)
            make.left.equalTo(contractNameLable)
            make.right.equalTo(contractNameLable)
            make.height.equalTo(20)
            make.bottom.equalToSuperview().offset(-kMargin)
        }
    }
    
}
