//
//  YHServiceCenterStepThreeTableHeadView.swift
//  galaxy
//
//  Created by EDY on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceCenterStepThreeTableHeadView: UIView {
    typealias Block = ([YHServiceCenterProgressModel]) -> ()
    var block: Block?
    
    var dataSource: [YHServiceStepProgressThreeModel] = [] {
        didSet {
            selectIndex = 0
            let model = dataSource[selectIndex]
            explainLabel.text = model.personStr
            if model.personStr.count > 20 {
                moreButton.isHidden = false
            } else {
                moreButton.isHidden = true
            }
            self.myCollectView.reloadData()
        }
    }
    var bgView: UIView!
    var moreButton: UIButton!
    var explainLabel: UILabel!
    var selectIndex = 0
    lazy var myCollectView = {
        // 设置布局方向
        let flowLayout = UICollectionViewFlowLayout()
        flowLayout.itemSize = CGSize(width: 81, height: 26)
        flowLayout.minimumInteritemSpacing = 12.0
        flowLayout.minimumLineSpacing = 12.0
        flowLayout.scrollDirection = .horizontal
        
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.backgroundColor = .clear
        collectinoView.contentInset = UIEdgeInsets(top: 16, left: 20, bottom: 16, right: 20)
        collectinoView.register(YHServiceSectionStepThreeCollectionViewCell.self, forCellWithReuseIdentifier:YHServiceSectionStepThreeCollectionViewCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.translatesAutoresizingMaskIntoConstraints = false
        collectinoView.alwaysBounceVertical = true
        collectinoView.bounces = false
        collectinoView.showsHorizontalScrollIndicator = false
        collectinoView.showsVerticalScrollIndicator = false
        return collectinoView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        backgroundColor = .clear
        addSubview(myCollectView)
        myCollectView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(58)
        }
        
        bgView = {
            let view = UIView()
            view.backgroundColor = UIColor.pageBkgColor
            return view
        }()
        addSubview(bgView)
        bgView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.height.equalTo(42)
            make.left.equalTo(20)
            make.right.equalTo(-20)
        }
        
        explainLabel = {
            let label = UILabel()
            label.textColor = UIColor.mainTextColor70
            label.text = "本期人员：张大大 (首次)、张笑笑 (第2次)"
            label.font = UIFont.PFSC_M(ofSize: 13)
            return label
        }()
        bgView.addSubview(explainLabel)
        explainLabel.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(12)
            make.right.equalTo(-38)
        }
        
        moreButton = {
            let button = UIButton(type: .custom)
            button.setTitle("更多", for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
            button.addTarget(self, action: #selector(showAlert), for: .touchUpInside)
            return button
        }()
        bgView.addSubview(moreButton)
        moreButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.width.equalTo(26)
            make.height.equalTo(18)
            make.right.equalTo(-12)
        }
//        self.myCollectView.es.addInfiniteScrolling {
//            self.loadFakeData()
//        }
    }
    
    @objc func showAlert() {
        YHCommonAlertView.show("", explainLabel.text, "我知道了",fullGuestureEnable: false) {
            
        } callBack: {
            
        }
    }
}

extension YHServiceCenterStepThreeTableHeadView: UICollectionViewDelegate, UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return dataSource.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHServiceSectionStepThreeCollectionViewCell.cellReuseIdentifier, for: indexPath) as! YHServiceSectionStepThreeCollectionViewCell
        cell.dataSource = indexPath.row + 1
        if indexPath.row == selectIndex {
            cell.setSelectedStyle()
        } else {
            cell.setDeSelectedStyle()
        }
        return cell
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        selectIndex = indexPath.row
        let model = dataSource[selectIndex]
        explainLabel.text = model.personStr
        if model.personStr.count > 20 {
            moreButton.isHidden = false
        } else {
            moreButton.isHidden = true
        }
        collectionView.reloadData()
        let array = model.list
        if let block = block {
            block(array)
        }
    }
}

class YHServiceSectionStepThreeCollectionViewCell: UICollectionViewCell {
    static let cellReuseIdentifier = "YHServiceSectionStepThreeCollectionViewCell"
 
    func setSelectedStyle() {
        descripeLable.textColor = UIColor.mainTextColor
        descripeLable.layer.borderColor = UIColor.mainTextColor.cgColor
    }
 
    func setDeSelectedStyle() {
        descripeLable.textColor = UIColor.mainTextColor50
        descripeLable.layer.borderColor = UIColor.mainTextColor18.cgColor
    }
    
    var dataSource: Int = 0 {
        didSet {
            updataAllSubViews()
        }
    }
    
    lazy var descripeLable:UILabel = {
        let label = UILabel()
        label.text = "赴港"
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textAlignment = .center
        label.layer.borderColor = UIColor.mainTextColor.cgColor
        label.layer.borderWidth = 1
        return label
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    private func setupUI() {
        contentView.addSubview(descripeLable)
        descripeLable.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
    }
    
    func updataAllSubViews() {
        descripeLable.text = "第\(dataSource)批续签"
    }
}
