//
//  YHServiceCenterViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceCenterViewModel: YHBaseViewModel {
    //合同列表 数据
    var arrContactList : [YHContactItemModel] = []
    //服务中心进度模型
    var arrDataForSeviceCenterProgress: [YHServiceCenterProgressModel] = []
    var mainModel: YHServiceCenterMainModel = YHServiceCenterMainModel()
}

//请求接口
extension YHServiceCenterViewModel {
    //请求合同项
    func getContactList(callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.contractListApi
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            arrContactList.removeAll()
            
            if json.code == 200 {
                
                DispatchQueue.global().async {
                    
                    guard let dic = json.data?.peel as? [String : Any],let resultModel = YHContactItemHoldModel.deserialize(from: dic) else {
                        
                        DispatchQueue.main.async {
                            self.arrContactList = []
                            callBackBlock(false,nil)
                        }
                        return
                    }
                    
                    DispatchQueue.main.async {
                        self.arrContactList = resultModel.orders
                        callBackBlock(true,nil)
                    }
                }
                
            } else {
                arrContactList = []
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code),errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false,error)
            }
        } failBlock: { err in
            self.arrContactList = []
            callBackBlock(false,err)
        }
    }
    
    func getServiceCenterProgressList(_ orderId: Int, _ type: Int,callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        /*
         orderId integer 订单id 可选
         status integer 可选   0全部 1待开始 2进行中 3 已完成
         let arr = ["orderId":id,"status"]
         */
        let params: [String : Any] = ["orderId": orderId,
                                      "status": type]

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.serviceCenterProgressApi
        
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                
                guard let dic = json.data?.peel as? [Any], let result = [YHServiceCenterProgressModel].deserialize(from:dic) else {
                    callBackBlock(false,nil)
                    return
                }
                self.arrDataForSeviceCenterProgress = result 
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    func getServiceMainData(orderId: Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let params: [String : Any] = ["orderId": orderId,
                                      "status": 0]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.main
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                
                DispatchQueue.global().async {
                    guard let dic = json.data?.peel as? [String : Any], let resultModel = YHServiceCenterMainModel.deserialize(from: dic) else {
                        DispatchQueue.main.async {
                            callBackBlock(false,nil)
                        }
                        return
                    }
                    
                    DispatchQueue.main.async {
                        self.mainModel = resultModel
                        callBackBlock(true,nil)
                    }
                }
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code),errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false,error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
}

