//
//  YHAllowUseMyInfoViewController.swift
//  galaxy
//
//  Created by EDY on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAllowUseMyInfoViewController: YHBaseViewController {
    var tableView: UITableView!
    var nextButton: UIButton!
    let items: [YHSettingItem] = [YHSettingItem(type: .normal, title: "允许您的信息在名片中使用", subTitle: "开启后，您的信息将自动同步至您的个人名片，并对您的好友公开可见", isSelect: true, isShowAlert: false)]
    var viewModel: YHUserInfoSettingViewModel = YHUserInfoSettingViewModel()
    var isOpen: Bool = true
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitle = "设置"
        gk_navBackgroundColor = .white
        gk_navBarAlpha = 1
        setView()
        // Do any additional setup after loading the view.
    }
    
    func setView() {
        view.backgroundColor = .contentBkgColor
        
        tableView = {
            let tableView = UITableView(frame:.zero, style:.grouped)
            if #available(iOS 11.0, *) {
                tableView.contentInsetAdjustmentBehavior = .never
            }
            tableView.backgroundColor = .white
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHAllowSettingTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom() - 48)
            make.left.right.equalTo(view)
        }
        
        nextButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("下一步", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(nextStep), for: .touchUpInside)
            return button
        }()
        view.addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-8 - k_Height_safeAreaInsetsBottom())
            make.height.equalTo(48)
        }
    }
    
    @objc func nextStep() {
        var open = 1
        if isOpen {
            open = 2
        }
        viewModel.requestAuthorizationSubmit(agress: open) {[weak self] success, error in
            guard let self = self else { return }
            viewModel.requestBusinessCardAuthorize {[weak self] success, error in
                guard let self = self else { return }
                TXCommonHandler.sharedInstance().cancelLoginVC(animated: true)
                self.dismiss(animated: true) {
                    let view = YHLoginOneLeadView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
                    let window = UIApplication.shared.yhKeyWindow()
                    window?.addSubview(view)
                }
            }
        }
    }
}

extension YHAllowUseMyInfoViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHAllowSettingTableViewCell.self)
        cell.item = items[indexPath.row]
        cell.block = { [weak self] model in
            guard let self = self else { return }
            self.isOpen = !self.isOpen
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 98.0
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 0.01))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
}
