//
//  YHLoginManager.swift
//  galaxy
//
//  Created by EDY on 2024/2/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHLoginManager: NSObject {
    static let shared = YHLoginManager()
    
    var userModel: YHUserModel?
    var deviceTokenModel : YHDeviceTokenModel = YHDeviceTokenModel()
    
    //检查到未登录的情况下 调用登录界面，在登录成功后，是否需要继续之前的行为
    typealias Block = () -> ()
    var loginSuccessActionBlock : Block?
    
    private override init() {}
    
    var needJumpToMsgTabFlag : Bool = false
    // 是否展示了版本更新
    var isShowVersionUpdate:Bool = false
}

extension YHLoginManager {
    func isLogin() -> Bool {
        let ttt = userModel?.token?.count ?? 0
        if ttt != 0 {
            return true
        }
        return false
    }
    
    // 保存用户数据到本地
    func saveLocalUserInfo() {
        if let userModel = userModel {
            UserDefaults.standard.set(userModel.toDictionary(), forKey: YhConstant.KLoginedInfoKey)
            UserDefaults.standard.synchronize()
        }
    }
    
    // 清空用户数据
    func clearUserInfo() {
        userModel = nil
        deviceTokenModel.registerId = ""
        UserDefaults.standard.set(nil, forKey: YhConstant.KLoginedInfoKey)
        UserDefaults.standard.synchronize()
    }
    
    func loadLocalUserInfoData() {
        
        guard let dic = UserDefaults.standard.value(forKey: YhConstant.KLoginedInfoKey) as? [String : Any],let resultModel = YHUserModel.deserialize(from: dic) else {
            return
        }
        self.userModel = resultModel
    }
}
