//
//  YHMsgListModel.swift
//  galaxy
//
//  Created by edy on 2024/4/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

enum YHMessageType: Int {
    case none = 0
    case infoFill = 1   // 资料填写
    case cerUpload = 2  // 证件上传
    case draft = 3      // 文书定稿
    case fileSign = 4   // 文件签字
    case infoSubmit = 5 // 资料递交
    case identityApproved = 6 // 身份获批
    case goToHK = 7 // 赴港办证
    case renewal = 8 // 身份续签
    
    case yinheManager = 9527 // 银河管家
}

class YHMessageInfoModel: SmartCodable {
    var unreadCount: Int = 0
    var lastMessage: String = ""
    var lastMessageTime: Int64 = 0
    var type: Int = 0
        
    required init() {
        
    }

    enum CodingKeys: String, CodingKey {
        case unreadCount = "unread_count"
        case lastMessage = "last_message"
        case lastMessageTime = "last_message_time"
        case type = "type"
    }
    
    func getTitle() -> String {
        
        if type == YHMessageType.yinheManager.rawValue {
            return "银河管家"
            
        } else if type == YHMessageType.infoFill.rawValue {
            return "资料填写"
            
        } else if type == YHMessageType.cerUpload.rawValue {
            return "证件上传"
            
        } else if type == YHMessageType.draft.rawValue {
            return "文书定稿"
            
        } else if type == YHMessageType.fileSign.rawValue {
            return "文件签字"
            
        } else if type == YHMessageType.infoSubmit.rawValue {
            return "资料递交"
            
        } else if type == YHMessageType.identityApproved.rawValue {
            return "身份获批"
            
        } else if type == YHMessageType.goToHK.rawValue {
            return "赴港办证"
            
        }  else if type == YHMessageType.renewal.rawValue {
            return "身份续签"
        }
        return ""
    }
}

class YHMsgListModel: SmartCodable {
    var information: YHMessageInfoModel = YHMessageInfoModel()
    var certificate: YHMessageInfoModel = YHMessageInfoModel()
    var draft: YHMessageInfoModel = YHMessageInfoModel()
    var signature: YHMessageInfoModel = YHMessageInfoModel()
    var dataSubmission: YHMessageInfoModel = YHMessageInfoModel()
    var approval: YHMessageInfoModel = YHMessageInfoModel()
    var goToHK: YHMessageInfoModel = YHMessageInfoModel()
    var renewal: YHMessageInfoModel = YHMessageInfoModel()
    
    required init() {
        self.information.type = YHMessageType.infoFill.rawValue
        self.certificate.type = YHMessageType.cerUpload.rawValue
        self.draft.type = YHMessageType.draft.rawValue
        self.signature.type = YHMessageType.fileSign.rawValue
        self.dataSubmission.type = YHMessageType.infoSubmit.rawValue
        self.approval.type = YHMessageType.identityApproved.rawValue
        self.goToHK.type = YHMessageType.goToHK.rawValue
        self.renewal.type = YHMessageType.renewal.rawValue
    }
    
    enum CodingKeys: String, CodingKey {
        case information, certificate, draft, signature, approval, renewal
        case dataSubmission = "data_submission"
        case goToHK = "go_to_hk"
    }
}

class YHDetailMessageModel: SmartCodable {
    
    var id: String = ""
    var title: String = ""
    var content: String = ""
    var time: Int = 0
    var isRead: Bool = false
    var orderId: String = ""
    var url: String = ""
    var redirectPage: String = ""
    
    required init() {
        
    }
    
    enum CodingKeys: String, CodingKey {
        case id, title, content, time, url
        case isRead = "is_read"
        case orderId = "order_id"
        case redirectPage = "redirect_page"
    }
}
