//
//  YHInformationFillCell.swift
//  galaxy
//
//  Created by edy on 2024/4/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHDetailMessageCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHDetailMessageCell"
    static let unreadPointWidth = 6.0
    
    var whiteView:UIView!
    var titleLabel:UILabel!
    var detailLabel:UILabel!
    var unreadPointView:UIView!
    var bottomBtn:UIButton!
    var lineView:UIView!
    var timeLabel:UILabel!
    var model:YHDetailMessageModel?

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func updateModel(_ model: YHDetailMessageModel, type:Int) {
        self.model = model
        titleLabel.text = model.title
        detailLabel.text = model.content
        unreadPointView.isHidden = model.isRead
        timeLabel.text = formatTimestamp(Double(model.time))
        
        if type == YHMessageType.infoFill.rawValue {
            bottomBtn.setTitle("去填写".local, for: .normal)

        } else if type == YHMessageType.cerUpload.rawValue {
            bottomBtn.setTitle("去上传".local, for: .normal)

        } else if type == YHMessageType.draft.rawValue {
            bottomBtn.setTitle("去定稿".local, for: .normal)

        } else if type == YHMessageType.fileSign.rawValue {
            bottomBtn.setTitle("去签字".local, for: .normal)
            
        } else if type == YHMessageType.infoSubmit.rawValue {
            bottomBtn.setTitle("去查看".local, for: .normal)
            if !model.url.isEmpty {
                bottomBtn.setTitle("去签字".local, for: .normal)
            }
            
        } else if type == YHMessageType.identityApproved.rawValue {
            bottomBtn.setTitle("去查看".local, for: .normal)
            
        } else if type == YHMessageType.goToHK.rawValue {
            bottomBtn.setTitle("去查看".local, for: .normal)
        
        } else if type == YHMessageType.renewal.rawValue {
            bottomBtn.setTitle("去查看".local, for: .normal)
        }
    }

    
    func formatTimestamp(_ timestamp: TimeInterval) -> String {
        let currentDate = Date()
        let calendar = Calendar.current
        let currentYear = calendar.component(.year, from: currentDate)
        let currentDay = calendar.component(.day, from: currentDate)
        
        let date = Date(timeIntervalSince1970: timestamp)
        let year = calendar.component(.year, from: date)
        let day = calendar.component(.day, from: date)
        
        let dateFormatter = DateFormatter()
        
        if year == currentYear {
            if day == currentDay {
                dateFormatter.dateFormat = "HH:mm"
            } else {
                dateFormatter.dateFormat = "MM-dd"
            }
        } else {
            dateFormatter.dateFormat = "yyyy-MM-dd"
        }
        
        return dateFormatter.string(from: date)
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = UIColor(hex:0xF8F8F8)
        
        timeLabel = UILabel()
        timeLabel.textColor = UIColor.mainTextColor30
        timeLabel.textAlignment = .center
        timeLabel.font = UIFont.PFSC_R(ofSize:12)
        timeLabel.text = "2023-09-13"
        contentView.addSubview(timeLabel)

        whiteView = UIView()
        whiteView.backgroundColor = .white
        whiteView.layer.cornerRadius = kCornerRadius6
        whiteView.clipsToBounds = true
        contentView.addSubview(whiteView)
        
        titleLabel = UILabel()
        titleLabel.textColor = UIColor(hex: 0x222222)
        titleLabel.textAlignment = .left
        titleLabel.font = UIFont.PFSC_M(ofSize:17)
        titleLabel.text = "资料填写提醒".local
        whiteView.addSubview(titleLabel)
        
        unreadPointView = UIView()
        unreadPointView.backgroundColor = UIColor.failColor
        unreadPointView.layer.cornerRadius = Self.unreadPointWidth/2.0
        unreadPointView.clipsToBounds = true
        whiteView.addSubview(unreadPointView)

        detailLabel = UILabel()
        detailLabel.textAlignment = .left
        detailLabel.numberOfLines = 0
        detailLabel.font = UIFont.PFSC_R(ofSize:14)
        detailLabel.textColor = UIColor.mainTextColor70
        whiteView.addSubview(detailLabel)
        
        lineView = UIView()
        lineView.backgroundColor = UIColor(hex:0xF8F8F8)
        whiteView.addSubview(lineView)

        bottomBtn = UIButton()
        bottomBtn.isUserInteractionEnabled = false
        bottomBtn.setTitle("去填写".local, for: .normal)
        bottomBtn.setTitleColor(UIColor.brandMainColor, for: .normal)
        bottomBtn.titleLabel?.font = .PFSC_R(ofSize: 14)
        bottomBtn.addTarget(self, action: #selector(didBottomBtnClicked), for: .touchUpInside)
        whiteView.addSubview(bottomBtn)
        
        timeLabel.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(46.0)
        }
        
        whiteView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.top.equalTo(timeLabel.snp.bottom)
            make.bottom.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.top.equalToSuperview().offset(16)
            make.height.equalTo(24.0)
        }
        
        unreadPointView.snp.makeConstraints { make in
            make.width.height.equalTo(Self.unreadPointWidth)
            make.left.equalTo(titleLabel.snp.right).offset(4)
            make.centerY.equalTo(titleLabel)
            make.right.lessThanOrEqualToSuperview().offset(-16)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(detailLabel.snp.bottom).offset(16)
            make.height.equalTo(1)
        }
        
        bottomBtn.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom)
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(52)
        }
    }
    
    @objc func didBottomBtnClicked() {
        
    }
    
    func updateModel() {
        
        let text1: ASAttributedString = .init("林先生，您好，您尚有20%内容未填写，请到", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
        
        let text2: ASAttributedString = .init("服务中心-资料上传", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.brandMainColor), .action {
            
        })
        let text3: ASAttributedString = .init("去填写，请您尽快完成～", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor70))
        
        detailLabel.attributed.text = text1 + text2 + text3
    }

}
